/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.environment;

import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Contract;

public final class EnvironmentDefinition {
    private static final int DEFAULT_PRIORITY = 1000;
    public static final Codec<EnvironmentDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6895.method_40340((class_5321)class_7924.field_41236).fieldOf("biomes").forGetter(EnvironmentDefinition::biomes), (App)class_6895.method_40340((class_5321)class_7924.field_41236).optionalFieldOf("exclude_biomes", (Object)class_6885.method_58563()).forGetter(EnvironmentDefinition::excludeBiomes), (App)EnvironmentProvider.ENTRY_CODEC.fieldOf("provider").forGetter(EnvironmentDefinition::provider), (App)Codec.INT.optionalFieldOf("priority", (Object)1000).forGetter(EnvironmentDefinition::priority)).apply((Applicative)instance, EnvironmentDefinition::new));
    private final class_6885<class_1959> biomes;
    private final class_6885<class_1959> excludeBiomes;
    private final class_6880<EnvironmentProvider> provider;
    private final int priority;

    private EnvironmentDefinition(class_6885<class_1959> biomes, class_6885<class_1959> excludeBiomes, class_6880<EnvironmentProvider> provider, int priority) {
        this.biomes = biomes;
        this.excludeBiomes = excludeBiomes;
        this.provider = provider;
        this.priority = priority;
    }

    public static Builder builder(class_6885<class_1959> biomes, class_6880<EnvironmentProvider> provider) {
        return new Builder(biomes, provider);
    }

    @Deprecated(since="4.5")
    @Contract(value="_,_->new")
    public static EnvironmentDefinition create(class_6885<class_1959> biomes, class_6880<EnvironmentProvider> provider) {
        return EnvironmentDefinition.builder(biomes, provider).build();
    }

    @Deprecated(since="4.5")
    @Contract(value="_,_,_->new")
    public static EnvironmentDefinition create(class_6885<class_1959> biomes, class_6885<class_1959> excludeBiomes, class_6880<EnvironmentProvider> provider) {
        return EnvironmentDefinition.builder(biomes, provider).excludeBiomes(excludeBiomes).build();
    }

    public boolean providesFor(class_6880<class_1959> biome) {
        return this.biomes().method_40241(biome) && !this.excludeBiomes().method_40241(biome);
    }

    public class_6885<class_1959> biomes() {
        return this.biomes;
    }

    public class_6885<class_1959> excludeBiomes() {
        return this.excludeBiomes;
    }

    public class_6880<EnvironmentProvider> provider() {
        return this.provider;
    }

    public int priority() {
        return this.priority;
    }

    public static class Builder {
        private final class_6885<class_1959> biomes;
        private final class_6880<EnvironmentProvider> provider;
        private class_6885<class_1959> excludeBiomes = class_6885.method_58563();
        private int priority = 1000;

        private Builder(class_6885<class_1959> biomes, class_6880<EnvironmentProvider> provider) {
            this.biomes = biomes;
            this.provider = provider;
        }

        public Builder excludeBiomes(class_6885<class_1959> biomes) {
            this.excludeBiomes = biomes;
            return this;
        }

        public Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public EnvironmentDefinition build() {
            return new EnvironmentDefinition(this.biomes, this.excludeBiomes, this.provider, this.priority);
        }
    }
}

