/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.impl;

import com.github.thedeathlycow.thermoo.api.environment.EnvironmentLookup;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingMode;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentTickContext;
import com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntitySoakingTickEvents;
import com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents;
import com.github.thedeathlycow.thermoo.impl.component.EnvironmentComponent;
import com.github.thedeathlycow.thermoo.impl.component.ThermooComponents;
import com.github.thedeathlycow.thermoo.impl.environment.EnvironmentTickContextImpl;
import com.github.thedeathlycow.thermoo.impl.environment.ServerPlayerTickUtil;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_9323;

public final class LivingEntityTickUtil {
    public static void tick(class_1309 entity) {
        if (entity.method_29504() || entity.method_31481()) {
            return;
        }
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            boolean isSyncTick;
            class_3218 serverWorld = (class_3218)class_19372;
            class_2338 pos = LivingEntityTickUtil.getTemperatureTickPos(entity);
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                EnvironmentTickContextImpl<class_3222> context = new EnvironmentTickContextImpl<class_3222>(player, serverWorld, pos, EnvironmentLookup.getInstance().findEnvironmentComponents((class_1937)serverWorld, pos));
                LivingEntityTickUtil.invokeEntityEvents(context);
                ServerPlayerTickUtil.invokePlayerTemperatureEvents(context);
            } else {
                EnvironmentTickContextImpl<class_1309> context = new EnvironmentTickContextImpl<class_1309>(entity, serverWorld, pos, class_9323.field_49584);
                LivingEntityTickUtil.invokeEntityEvents(context);
            }
            boolean bl = isSyncTick = entity.field_6012 % 20 == 0;
            if (isSyncTick || ((EnvironmentComponent)ThermooComponents.TEMPERATURE.get((Object)entity)).isDirty()) {
                ThermooComponents.TEMPERATURE.sync((Object)entity);
            }
            if (isSyncTick || ((EnvironmentComponent)ThermooComponents.WETNESS.get((Object)entity)).isDirty()) {
                ThermooComponents.WETNESS.sync((Object)entity);
            }
        }
    }

    public static class_2338 getTemperatureTickPos(class_1309 entity) {
        class_243 pos = entity.method_19538();
        float offset = 0.21f;
        if (entity.field_44784.isPresent()) {
            class_2338 blockPos = (class_2338)entity.field_44784.get();
            class_2680 blockState = entity.method_37908().method_8320(blockPos);
            return !blockState.method_26164(class_3481.field_16584) && !blockState.method_26164(class_3481.field_15504) && !(blockState.method_26204() instanceof class_2349) ? blockPos.method_33096(class_3532.method_15357((double)(pos.field_1351 + (double)0.21f))) : blockPos;
        }
        return new class_2338(class_3532.method_15357((double)pos.field_1352), class_3532.method_15357((double)(pos.field_1351 + (double)0.21f)), class_3532.method_15357((double)pos.field_1350));
    }

    private static void invokeEntityEvents(EnvironmentTickContext<? extends class_1309> context) {
        LivingEntityTickUtil.tickSoakingChange(context, LivingEntitySoakingTickEvents.ALLOW_SOAKING_UPDATE, LivingEntitySoakingTickEvents.GET_SOAKING_CHANGE, LivingEntitySoakingTickEvents.ALLOW_SOAKING_CHANGE);
        LivingEntityTickUtil.tickTemperatureChange(context, HeatingModes.PASSIVE, LivingEntityTemperatureTickEvents.ALLOW_PASSIVE_TEMPERATURE_UPDATE, LivingEntityTemperatureTickEvents.GET_PASSIVE_TEMPERATURE_CHANGE, LivingEntityTemperatureTickEvents.ALLOW_PASSIVE_TEMPERATURE_CHANGE);
        LivingEntityTickUtil.tickTemperatureChange(context, HeatingModes.ACTIVE, LivingEntityTemperatureTickEvents.ALLOW_ACTIVE_TEMPERATURE_UPDATE, LivingEntityTemperatureTickEvents.GET_ACTIVE_TEMPERATURE_CHANGE, LivingEntityTemperatureTickEvents.ALLOW_ACTIVE_TEMPERATURE_CHANGE);
    }

    private static void tickTemperatureChange(EnvironmentTickContext<? extends class_1309> context, HeatingMode heatingMode, Event<LivingEntityTemperatureTickEvents.AllowTemperatureUpdate> allowUpdate, Event<LivingEntityTemperatureTickEvents.GetTemperatureChange> getTempChange, Event<LivingEntityTemperatureTickEvents.AllowTemperatureChange> allowChange) {
        if (((LivingEntityTemperatureTickEvents.AllowTemperatureUpdate)allowUpdate.invoker()).allowUpdate(context) == TriState.FALSE) {
            return;
        }
        int tempChange = ((LivingEntityTemperatureTickEvents.GetTemperatureChange)getTempChange.invoker()).addTemperature(context);
        if (tempChange != 0 && ((LivingEntityTemperatureTickEvents.AllowTemperatureChange)allowChange.invoker()).allowChange(context, tempChange) != TriState.FALSE) {
            context.affected().thermoo$addTemperature(tempChange, heatingMode);
        }
    }

    private static void tickSoakingChange(EnvironmentTickContext<? extends class_1309> context, Event<LivingEntitySoakingTickEvents.AllowSoakingUpdate> allowUpdate, Event<LivingEntitySoakingTickEvents.GetSoakingChange> addSoakChange, Event<LivingEntitySoakingTickEvents.AllowSoakingChange> allowChange) {
        if (((LivingEntitySoakingTickEvents.AllowSoakingUpdate)allowUpdate.invoker()).allowUpdate(context) == TriState.FALSE) {
            return;
        }
        int soakingChange = ((LivingEntitySoakingTickEvents.GetSoakingChange)addSoakChange.invoker()).addChange(context);
        if (soakingChange != 0 && ((LivingEntitySoakingTickEvents.AllowSoakingChange)allowChange.invoker()).allowChange(context, soakingChange) != TriState.FALSE) {
            context.affected().thermoo$addWetTicks(soakingChange);
        }
    }

    private LivingEntityTickUtil() {
    }
}

