package com.github.thedeathlycow.thermoo.api.temperature;

import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

/**
 * Decorator for the {@link EnvironmentController}, to be extended by other mods for the purpose of adding or replacing
 * functionality from the default environment controller.
 * <p>
 * Every method by default delegates to the base {@link #controller}
 *
 * @deprecated Replaced with {@linkplain com.github.thedeathlycow.thermoo.api.environment.EnvironmentDefinition the environment datapack registry}
 */
@Deprecated
public abstract non-sealed class EnvironmentControllerDecorator implements EnvironmentController {

    /**
     * The base controller to decorate with new functionality. This field may never be {@code null}
     */
    @NotNull
    protected final EnvironmentController controller;

    /**
     * Constructs a decorator out of a base controller
     *
     * @param controller The base {@link #controller}
     */
    protected EnvironmentControllerDecorator(EnvironmentController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("The base controller for the decorator may not be null!");
        }

        this.controller = controller;
    }

    /**
     * Getter for the base controller
     *
     * @return Returns the decorated base controller
     */
    @Override
    @NotNull
    public final EnvironmentController getDecorated() {
        return this.controller;
    }

    /**
     * @deprecated Replaced with {@link com.github.thedeathlycow.thermoo.api.ThermooAttributes#baseValueEvent(class_6880)}
     */
    @Override
    @Deprecated(since = "5.1")
    public double getBaseValueForAttribute(class_6880<class_1320> attribute, class_1309 entity) {
        return controller.getBaseValueForAttribute(attribute, entity);
    }

    /**
     * @deprecated Replaced with {@link com.github.thedeathlycow.thermoo.api.environment.event.ServerPlayerEnvironmentTickEvents}
     */
    @Override
    @Deprecated(since = "4.4")
    public int getLocalTemperatureChange(class_1937 world, class_2338 pos) {
        return controller.getLocalTemperatureChange(world, pos);
    }

    /**
     * @deprecated Replaced with {@link com.github.thedeathlycow.thermoo.api.environment.event.ServerPlayerEnvironmentTickEvents}
     */
    @Override
    @Deprecated(since = "4.4")
    public int getEnvironmentTemperatureForPlayer(class_1657 player, int localTemperature) {
        return controller.getEnvironmentTemperatureForPlayer(player, localTemperature);
    }

    /**
     * @deprecated Replaced with active effects in {@link com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents}
     */
    @Override
    @Deprecated(since = "4.4")
    public int getTemperatureEffectsChange(class_1309 entity) {
        return controller.getTemperatureEffectsChange(entity);
    }

    /**
     * @deprecated Replaced with passive effects in {@link com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents}
     */
    @Override
    @Deprecated(since = "4.4")
    public int getFloorTemperature(class_1309 entity, class_1937 world, class_2680 state, class_2338 pos) {
        return controller.getFloorTemperature(entity, world, state, pos);
    }

    @Override
    public int getMaxWetTicks(Soakable soakable) {
        return controller.getMaxWetTicks(soakable);
    }

    @Override
    public int getSoakChange(Soakable soakable) {
        return controller.getSoakChange(soakable);
    }

    /**
     * @deprecated Replaced with passive effects in {@link com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents}
     */
    @Override
    @Deprecated(since = "4.4")
    public int getHeatAtLocation(class_1937 world, class_2338 pos) {
        return controller.getHeatAtLocation(world, pos);
    }

    /**
     * @deprecated Replaced with passive effects in {@link com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents}
     */
    @Override
    @Deprecated(since = "4.4")
    public int applyAwareHeat(TemperatureAware temperatureAware, int locationHeat) {
        return controller.applyAwareHeat(temperatureAware, locationHeat);
    }

    /**
     * @deprecated Replaced with passive effects in {@link com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents}
     */
    @Override
    @Deprecated(since = "4.4")
    public int getHeatFromBlockState(class_2680 state) {
        return controller.getHeatFromBlockState(state);
    }

    /**
     * @deprecated Replaced with passive effects in {@link com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents}
     */
    @Override
    @Deprecated(since = "4.4")
    public boolean isHeatSource(class_2680 state) {
        return controller.isHeatSource(state);
    }

    /**
     * @deprecated Replaced with passive effects in {@link com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents}
     */
    @Override
    @Deprecated(since = "4.4")
    public boolean isColdSource(class_2680 state) {
        return controller.isColdSource(state);
    }

    /**
     * @deprecated Replaced with passive effects in {@link com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents}
     */
    @Override
    @Deprecated(since = "4.4")
    public boolean isAreaHeated(class_1937 world, class_2338 pos) {
        return controller.isAreaHeated(world, pos);
    }

    /**
     * Wraps the class name around the string representation of the {@link #controller} so that it is easy to see which mods
     * are decorating the Thermoo environment controller
     * <p>
     * Subclasses may not override this method any further.
     *
     * @return Returns the class name of this class, and the string representation of the {@link #controller}
     */
    @Override
    public final String toString() {
        return String.format("%s{%s}", this.getClass().getName(), this.controller.toString());
    }
}
