package com.github.thedeathlycow.thermoo.api.temperature.effects;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_6885;

/**
 * Applies multiple child temperature effects at once. Useful for when you want to apply several different temperature
 * effects under the same base set of conditions, without the overhead of checking those conditions multiple times.
 */
public class SequenceTemperatureEffect extends TemperatureEffect<SequenceTemperatureEffect.Config> {

    public static final Codec<Config> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                    Codec.list(ConfiguredTemperatureEffect.CODEC)
                            .fieldOf("children")
                            .forGetter(Config::children)
            ).apply(instance, Config::new)
    );

    public SequenceTemperatureEffect(Codec<Config> configCodec) {
        super(configCodec);
    }

    @Override
    public void apply(class_1309 victim, class_3218 serverWorld, Config config) {
        for (ConfiguredTemperatureEffect<?> child : config.children()) {
            class_6885<class_1299<?>> allowedTypes = child.entityTypes();
            if (allowedTypes.method_40247() == 0 || victim.method_5864().method_53125(allowedTypes)) {
                child.apply(victim);
            }
        }
    }

    @Override
    public boolean shouldApply(class_1309 victim, Config config) {
        return true;
    }

    public record Config(List<ConfiguredTemperatureEffect<?>> children) {

    }

}
