package com.github.thedeathlycow.thermoo.api.temperature.effects;


import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

/**
 * Applies {@link class_1291}s to {@link class_1309}s if their temperature scale is within a given range.
 * <p>
 * The type, duration, and intensity can all be configured of each status effect can be configured. May specify 1 or more
 * effects to all be applied at once.
 */
public class StatusEffectTemperatureEffect extends TemperatureEffect<StatusEffectTemperatureEffect.Config> {

    public static final Codec<Config> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                    Codec.list(Config.ConfigEffect.CODEC)
                            .fieldOf("effects")
                            .forGetter(Config::effects)
            ).apply(instance, Config::new)
    );

    public StatusEffectTemperatureEffect(Codec<Config> configCodec) {
        super(configCodec);
    }

    @Override
    public void apply(class_1309 victim, class_3218 serverWorld, Config config) {
        for (Config.ConfigEffect effect : config.effects) {
            this.addEffect(victim, effect);
        }
    }

    private void addEffect(class_1309 victim, Config.ConfigEffect effect) {
        class_1293 existingEffect = victim.method_6112(effect.type);
        if (existingEffect != null) {
            if (existingEffect.method_5578() == effect.amplifier && existingEffect.method_5584() > effect.duration / 2) {
                return;
            }
        }

        victim.method_37222(
                new class_1293(
                        effect.type,
                        effect.duration,
                        effect.amplifier,
                        true, true
                ),
                null
        );
    }

    @Override
    public boolean shouldApply(class_1309 victim, Config config) {
        // only try to apply every 5 ticks
        return victim.field_6012 % 5 == 0;
    }

    public record Config(
            List<ConfigEffect> effects
    ) {
        protected record ConfigEffect(
                class_6880<class_1291> type,
                int duration,
                int amplifier
        ) {

            public static final Codec<ConfigEffect> CODEC = RecordCodecBuilder.create(
                    instance -> {
                        return instance.group(
                                class_7923.field_41174.method_40294()
                                        .fieldOf("effect")
                                        .forGetter(ConfigEffect::type),
                                class_5699.field_33442
                                        .fieldOf("duration")
                                        .orElse(20)
                                        .forGetter(ConfigEffect::duration),
                                class_5699.field_33441
                                        .fieldOf("amplifier")
                                        .forGetter(ConfigEffect::amplifier)
                        ).apply(instance, ConfigEffect::new);
                    }
            );
        }
    }
}
