package com.github.thedeathlycow.thermoo.impl;

import com.github.thedeathlycow.thermoo.api.ThermooAttributes;
import com.github.thedeathlycow.thermoo.api.armor.material.ArmorMaterialEvents;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9285;

public enum ThermalResistanceType {

    COLD(
            ArmorMaterialEvents.GET_FROST_RESISTANCE,
            ThermooAttributes.FROST_RESISTANCE,
            "armor.frost_resistance"
    ),
    HEAT(
            ArmorMaterialEvents.GET_HEAT_RESISTANCE,
            ThermooAttributes.HEAT_RESISTANCE,
            "armor.heat_resistance"
    );
    private final Event<ArmorMaterialEvents.GetResistance> event;
    private final class_6880<class_1320> attribute;
    private final String modifierId;

    ThermalResistanceType(
            Event<ArmorMaterialEvents.GetResistance> event,
            class_6880<class_1320> attribute,
            String modifierId
    ) {
        this.event = event;
        this.attribute = attribute;
        this.modifierId = modifierId;
    }

    public void buildResistance(
            class_6880<class_1741> armorMaterial,
            class_1738.class_8051 type,
            class_9285.class_9286 builder
    ) {
        double resistanceValue = this.getResistanceValue(armorMaterial, type);

        if (resistanceValue != 0 && !Double.isNaN(resistanceValue)) {
            builder.method_57487(
                    attribute,
                    new class_1322(
                            Thermoo.id(this.modifierId + "." + type.method_48400()),
                            resistanceValue,
                            class_1322.class_1323.field_6328
                    ),
                    class_9274.method_59524(type.method_48399())
            );
            if (Thermoo.LOGGER.isDebugEnabled()) {
                Thermoo.LOGGER.debug("Applying {} {} to armor material {}", resistanceValue, attribute, armorMaterial);
            }
        }
    }

    private double getResistanceValue(class_6880<class_1741> armorMaterial, class_1738.class_8051 type) {
        return this.event.invoker().getValue(armorMaterial, type);
    }
}
