package com.github.thedeathlycow.thermoo.impl;

import com.github.thedeathlycow.thermoo.api.ThermooRegistryKeys;
import com.github.thedeathlycow.thermoo.api.command.*;
import com.github.thedeathlycow.thermoo.api.environment.EnvironmentDefinition;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentManager;
import com.github.thedeathlycow.thermoo.impl.compat.init.DependentModInitializer;
import com.github.thedeathlycow.thermoo.impl.config.ThermooConfig;
import com.github.thedeathlycow.thermoo.impl.environment.EnvironmentLookupImpl;
import com.github.thedeathlycow.thermoo.impl.temperature.effect.TemperatureEffectLoader;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.List;

public class Thermoo implements ModInitializer {
    public static final String MODID = "thermoo";

    public static final Logger LOGGER = LoggerFactory.getLogger(MODID);

    public static final class_2314<
            HeatingModeArgumentType,
            class_2319<HeatingModeArgumentType>.class_7219
            > HEATING_MODE_ARG_SERIALIZER = class_2319.method_41999(HeatingModeArgumentType::heatingMode);


    public static final class_2314<
            TemperatureUnitArgumentType,
            class_2319<TemperatureUnitArgumentType>.class_7219
            > TEMPERATURE_UNIT_ARG_SERIALIZER = class_2319.method_41999(TemperatureUnitArgumentType::temperatureUnit);

    @Nullable
    private static ThermooConfig config = null;


    @Override
    public void onInitialize() {
        ArgumentTypeRegistry.registerArgumentType(
                Thermoo.id("heating_mode"),
                HeatingModeArgumentType.class,
                HEATING_MODE_ARG_SERIALIZER
        );

        ArgumentTypeRegistry.registerArgumentType(
                Thermoo.id("temperature_unit"),
                TemperatureUnitArgumentType.class,
                TEMPERATURE_UNIT_ARG_SERIALIZER
        );

        CommandRegistrationCallback.EVENT.register(
                (dispatcher, registryAccess, environment) -> {
                    dispatcher.register(TemperatureCommand.COMMAND_BUILDER.get());
                    dispatcher.register(EnvironmentCommand.COMMAND_BUILDER.get());
                    dispatcher.register(SoakingCommand.COMMAND_BUILDER.get());
                }
        );

        DynamicRegistries.register(
                ThermooRegistryKeys.ENVIRONMENT,
                EnvironmentDefinition.CODEC
        );
        DynamicRegistries.register(
                ThermooRegistryKeys.ENVIRONMENT_PROVIDER,
                EnvironmentProvider.ELEMENT_CODEC
        );
        ThermooCommonRegisters.registerTemperatureEffects();
        ThermooCommonRegisters.registerEnvironmentProviderTypes();
        ThermooCommonRegisters.registerLootConditionTypes();

        ResourceManagerHelper serverManager = ResourceManagerHelper.get(class_3264.field_14190);
        serverManager.registerReloadListener(TemperatureEffectLoader.ID, TemperatureEffectLoader::new);

        EnvironmentLookupImpl.initialize();

        LOGGER.info("Creating environment manager {}", EnvironmentManager.INSTANCE);
        initializeDependentEntryPoints();

        LOGGER.info("Thermoo initialized");
    }

    /**
     * Creates a new {@link class_2960} under the namespace {@value #MODID}
     *
     * @param path The identifier path
     * @return Returns a new {@link class_2960}
     */
    @Contract("_->new")
    public static class_2960 id(String path) {
        return class_2960.method_60655(MODID, path);
    }

    public static ThermooConfig getConfig() {
        if (config == null) {
            config = ThermooConfig.create();
        }
        return config;
    }

    private static void initializeDependentEntryPoints() {
        List<DependentModInitializer> initializers = FabricLoader.getInstance().getEntrypoints(
                DependentModInitializer.ID,
                DependentModInitializer.class
        );

        for (DependentModInitializer initializer : initializers) {
            boolean initialize = Arrays.stream(initializer.getRequiredModIds()).allMatch(
                    id -> FabricLoader.getInstance().isModLoaded(id)
            );

            if (initialize) {
                initializer.onInitialize();
            }
        }
    }
}
