package com.github.thedeathlycow.thermoo.api.environment.provider;

import com.github.thedeathlycow.thermoo.api.environment.component.EnvironmentComponentTypes;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_6880;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Contract;

/**
 * Provides constant component values
 */
public final class ConstantEnvironmentProvider implements EnvironmentProvider {
    public static final MapCodec<ConstantEnvironmentProvider> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                    EnvironmentComponentTypes.COMPONENT_MAP_CODEC
                            .fieldOf("components")
                            .forGetter(ConstantEnvironmentProvider::components)
            ).apply(instance, ConstantEnvironmentProvider::new)
    );

    private final class_9323 components;

    private ConstantEnvironmentProvider(class_9323 components) {
        this.components = components;
    }

    /**
     * Creates a constant environment provider from a component map builder. The builder is built into a new component
     * map with this method, so modifying the builder after creating the provider will not affect the returned provider.
     *
     * @param builder The builder to create the provider from
     * @return Returns a new replacement environment provider
     */
    @Contract("_->new")
    public static ConstantEnvironmentProvider create(class_9323.class_9324 builder) {
        return new ConstantEnvironmentProvider(builder.method_57838());
    }

    /**
     * Adds the component map stored in this provider's {@link #components} to the builder. The components supplied by
     * this provider are immutable and never change. If a component type is mapped to a value in the builder and NOT
     * mapped to a value in this provider, then it will be unaffected.
     *
     * @param world   The world/level being queried
     * @param pos     The position in the world to query
     * @param biome   The biome at the position in the world
     * @param builder A component map builder to append to
     */
    @Override
    public void buildCurrentComponents(class_1937 world, class_2338 pos, class_6880<class_1959> biome, class_9323.class_9324 builder) {
        builder.method_57839(this.components);
    }

    @Override
    public EnvironmentProviderType<?> getType() {
        return EnvironmentProviderTypes.CONSTANT;
    }

    /**
     * Gets the component map stored in this provider. This is an {@link EnvironmentComponentTypes environment component}.
     */
    public class_9323 components() {
        return this.components;
    }
}