package com.github.thedeathlycow.thermoo.api.temperature.effects;

import com.github.thedeathlycow.thermoo.impl.Thermoo;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1309;
import net.minecraft.class_2158;
import net.minecraft.class_2159;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2991;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import net.minecraft.class_5699;
import net.minecraft.class_8643;
import net.minecraft.class_8854;
import net.minecraft.class_8868;
import net.minecraft.class_8935;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.function.*;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;

public final class FunctionTemperatureEffect extends TemperatureEffect<FunctionTemperatureEffect.Config> {

    static final int DEFAULT_PERMISSION_LEVEL = 2;

    public static final Codec<Config> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                    class_2159.field_47409
                            .fieldOf("function")
                            .forGetter(Config::function),
                    class_2522.field_45952
                            .optionalFieldOf("arguments")
                            .forGetter(Config::arguments),
                    class_5699.field_33442
                            .fieldOf("interval")
                            .orElse(20)
                            .forGetter(Config::interval),
                    Codec.intRange(0, 4)
                            .fieldOf("permission_level")
                            .orElse(DEFAULT_PERMISSION_LEVEL)
                            .forGetter(Config::permissionLevel)
            ).apply(instance, Config::new)
    );

    /**
     * @param configCodec Codec for the config type
     */
    public FunctionTemperatureEffect(Codec<Config> configCodec) {
        super(configCodec);
    }

    @Override
    public void apply(class_1309 victim, class_3218 serverWorld, Config config) {
        MinecraftServer server = serverWorld.method_8503();
        class_2991 functionManager = server.method_3740();

        config.function.method_9196(functionManager).ifPresent(
                func -> {
                    class_2168 commandSource = victim.method_5671()
                            .method_9217()
                            .method_9206(config.permissionLevel);

                    this.execute(
                            func,
                            commandSource,
                            server,
                            config.arguments.orElse(null)
                    );
                }
        );

    }

    @Override
    public boolean shouldApply(class_1309 victim, Config config) {
        return config.interval <= 1 || victim.field_6012 % config.interval == 0;
    }

    private void execute(
            class_2158<class_2168> function,
            class_2168 source,
            MinecraftServer server,
            @Nullable class_2487 arguments
    ) {
        class_3695 profiler = server.method_16044();
        profiler.method_15400(() -> "function " + function.comp_1994());

        try {
            class_8868<class_2168> procedure = function.method_52595(
                    arguments,
                    server.method_3734().method_9235()
            );
            class_2170.method_54313(
                    source,
                    context -> class_8854.method_54395(
                            context,
                            procedure,
                            source,
                            class_8935.field_47158
                    )
            );
        } catch (class_8643 e) {
            Thermoo.LOGGER.warn("Failed to apply macros to function {}", function.comp_1994(), e);
        } catch (Exception e) {
            Thermoo.LOGGER.warn("Failed to execute function {}", function.comp_1994(), e);
        } finally {
            profiler.method_15407();
        }
    }

    public record Config(
            class_2159 function,
            Optional<class_2487> arguments,
            int interval,
            int permissionLevel
    ) {

    }

}
