package com.github.thedeathlycow.thermoo.impl;

import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentController;
import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentManager;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import com.github.thedeathlycow.thermoo.api.temperature.event.PlayerEnvironmentEvents;
import com.github.thedeathlycow.thermoo.impl.component.ThermooComponents;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public class LivingEntityEnvironmentTickImpl {


    public static void tick(class_1309 entity) {
        class_1937 world = entity.method_37908();

        if (world.method_8608() || entity.method_7325() || entity.method_29504() || entity.method_31481()) {
            return;
        }

        EnvironmentController controller = EnvironmentManager.INSTANCE.getController();

        int tempChange;

        // tick area heat sources
        tempChange = controller.getHeatAtLocation(world, entity.method_5668().method_24515());
        tempChange = controller.applyAwareHeat(entity, tempChange);
        if (tempChange != 0) {
            entity.thermoo$addTemperature(tempChange, HeatingModes.PASSIVE);
        }

        tempChange = controller.getTemperatureEffectsChange(entity);
        if (tempChange != 0) {
            entity.thermoo$addTemperature(tempChange, HeatingModes.ACTIVE);
        }

        int soakChange = controller.getSoakChange(entity);
        boolean isSyncTick = entity.field_6012 % 20 == 0;

        if (soakChange != 0) {
            entity.thermoo$addWetTicks(soakChange);
        }

        if (isSyncTick || ThermooComponents.TEMPERATURE.get(entity).isDirty()) {
            ThermooComponents.TEMPERATURE.sync(entity);
        }

        if (isSyncTick || ThermooComponents.WETNESS.get(entity).isDirty()) {
            ThermooComponents.WETNESS.sync(entity);
        }
    }

    public static void tickPlayer(class_1657 player) {
        class_1937 world = player.method_37908();

        if (world.field_9236 || player.method_7325()) {
            return;
        }

        class_2338 pos = player.method_24515();
        var controller = EnvironmentManager.INSTANCE.getController();
        int temperatureChange = controller.getLocalTemperatureChange(world, pos);

        if (temperatureChange != 0) {

            TriState canApplyChange = PlayerEnvironmentEvents.CAN_APPLY_PASSIVE_TEMPERATURE_CHANGE
                    .invoker()
                    .canApplyChange(temperatureChange, player);

            if (canApplyChange != TriState.FALSE) {
                temperatureChange = controller.getEnvironmentTemperatureForPlayer(player, temperatureChange);
                player.thermoo$addTemperature(temperatureChange, HeatingModes.PASSIVE);
            }
        }
    }

    private LivingEntityEnvironmentTickImpl() {

    }

}
