package com.github.thedeathlycow.thermoo.impl;

import com.github.thedeathlycow.thermoo.api.ThermooRegistries;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProviderType;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProviderTypes;
import com.github.thedeathlycow.thermoo.api.predicate.ThermooLootConditionTypes;
import com.github.thedeathlycow.thermoo.api.temperature.effects.TemperatureEffect;
import com.github.thedeathlycow.thermoo.api.temperature.effects.TemperatureEffects;
import net.minecraft.class_2378;
import net.minecraft.class_5342;
import net.minecraft.class_7923;

public class ThermooCommonRegisters {
    public static void registerTemperatureEffects() {
        registerTemperatureEffect("empty", TemperatureEffects.EMPTY);
        registerTemperatureEffect("sequence", TemperatureEffects.SEQUENCE);
        registerTemperatureEffect("function", TemperatureEffects.FUNCTION);
        registerTemperatureEffect("status_effect", TemperatureEffects.STATUS_EFFECT);
        registerTemperatureEffect("scaling_attribute_modifier", TemperatureEffects.SCALING_ATTRIBUTE_MODIFIER);
        registerTemperatureEffect("attribute_modifier", TemperatureEffects.ATTRIBUTE_MODIFIER);
        registerTemperatureEffect("damage", TemperatureEffects.DAMAGE);
    }

    public static void registerEnvironmentProviderTypes() {
        registerEnvironmentProviderType("constant", EnvironmentProviderTypes.CONSTANT);
        registerEnvironmentProviderType("seasonal/temperate", EnvironmentProviderTypes.TEMPERATE_SEASONAL);
        registerEnvironmentProviderType("seasonal/tropical", EnvironmentProviderTypes.TROPICAL_SEASONAL);
        registerEnvironmentProviderType("modify", EnvironmentProviderTypes.MODIFY);
        registerEnvironmentProviderType("light_threshold", EnvironmentProviderTypes.LIGHT_THRESHOLD);
        registerEnvironmentProviderType("weather_state", EnvironmentProviderTypes.WEATHER_STATE);
        registerEnvironmentProviderType("precipitation_type", EnvironmentProviderTypes.PRECIPITATION_TYPE);
        registerEnvironmentProviderType("temperature_shift", EnvironmentProviderTypes.TEMPERATURE_SHIFT);
    }

    public static void registerLootConditionTypes() {
        registerLootConditionType("temperature", ThermooLootConditionTypes.TEMPERATURE);
        registerLootConditionType("soaked", ThermooLootConditionTypes.SOAKED);
    }

    private static void registerTemperatureEffect(String name, TemperatureEffect<?> temperatureEffect) {
        class_2378.method_10230(ThermooRegistries.TEMPERATURE_EFFECTS, Thermoo.id(name), temperatureEffect);
    }

    private static void registerEnvironmentProviderType(String name, EnvironmentProviderType<?> providerType) {
        class_2378.method_10230(ThermooRegistries.ENVIRONMENT_PROVIDER_TYPE, Thermoo.id(name), providerType);
    }

    private static void registerLootConditionType(String name, class_5342 lootConditionType) {
        class_2378.method_10230(class_7923.field_41135, Thermoo.id(name), lootConditionType);
    }
}
