package com.github.thedeathlycow.thermoo.impl.component;

import com.github.thedeathlycow.thermoo.impl.Thermoo;
import net.minecraft.class_1309;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.entity.EntityComponentFactoryRegistry;
import org.ladysnake.cca.api.v3.entity.EntityComponentInitializer;

public final class ThermooComponents implements EntityComponentInitializer {

    public static final ComponentKey<EnvironmentComponent> TEMPERATURE = ComponentRegistry.getOrCreate(
            Thermoo.id("temperature"),
            EnvironmentComponent.class
    );

    public static final ComponentKey<EnvironmentComponent> WETNESS = ComponentRegistry.getOrCreate(
            Thermoo.id("wetness"),
            EnvironmentComponent.class
    );

    public static final ComponentKey<TemperatureEffectsComponent> TEMPERATURE_EFFECTS = ComponentRegistry.getOrCreate(
            Thermoo.id("temperature_effects"),
            TemperatureEffectsComponent.class
    );


    @Override
    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.registerFor(
                class_1309.class,
                TEMPERATURE,
                EnvironmentComponent::new
        );
        registry.registerFor(
                class_1309.class,
                WETNESS,
                EnvironmentComponent::new
        );
        registry.registerFor(
                class_1309.class,
                TEMPERATURE_EFFECTS,
                TemperatureEffectsComponent::new
        );
    }
}
