package com.github.thedeathlycow.thermoo.mixin.client;

import com.github.thedeathlycow.thermoo.api.client.StatusBarOverlayRenderEvents;
import com.github.thedeathlycow.thermoo.impl.client.HeartOverlayTracker;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * For the mount health bar. For the player health bar see {@link InGameHudPlayerTemperatureMixin}
 */
@Mixin(class_329.class)
@Debug(export = true)
public abstract class InGameHudMountTemperatureMixin {
    @Shadow
    protected abstract class_1309 getRiddenEntity();

    @Shadow
    protected abstract class_1657 getCameraPlayer();

    @Shadow protected abstract int getHeartCount(@Nullable class_1309 entity);

    @Inject(
            method = "renderMountHealth",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/gui/DrawContext;drawGuiTexture(Lnet/minecraft/util/Identifier;IIII)V",
                    ordinal = 0
            )
    )
    private void captureMountHealth(
            class_332 context,
            CallbackInfo ci,
            @Local(ordinal = 8) int heartX,
            @Local(ordinal = 4) int heartY,
            @Share("thermoo_index") LocalIntRef index,
            @Share("thermoo_tracker") LocalRef<HeartOverlayTracker> tracker
    ) {
        if (tracker.get() == null) {
            tracker.set(new HeartOverlayTracker());
        }
        int indexValue = index.get();
        tracker.get().addHeartPosition(indexValue, heartX, heartY);
        index.set(indexValue + 1);
    }

    @Inject(
            method = "renderMountHealth",
            at = @At("TAIL")
    )
    private void renderMountHealth(
            class_332 context,
            CallbackInfo ci,
            @Share("thermoo_tracker") LocalRef<HeartOverlayTracker> tracker
    ) {
        Vector2i[] heartPositions = tracker.get().getHeartPositions();

        class_1657 player = this.getCameraPlayer();
        class_1309 mount = this.getRiddenEntity();

        // this weirdness accounts for two vanilla bugs:
        // - MC-200102: last half heart is not displayed with an odd max health
        // - a second bug that only shows up to 3 rows of mount health
        int maxHealth = this.getHeartCount(mount) * 2;
        int health = Math.min(class_3532.method_15386(mount.method_6032()), maxHealth);

        StatusBarOverlayRenderEvents.AFTER_MOUNT_HEALTH_BAR.invoker()
                .render(
                        context,
                        player,
                        mount,
                        heartPositions,
                        health,
                        maxHealth
                );
    }
}
