package com.github.thedeathlycow.thermoo.mixin.common;

import com.github.thedeathlycow.thermoo.impl.ThermalResistanceType;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_6880;
import net.minecraft.class_9285;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(class_1738.class)
public abstract class ArmorItemMixin {

    @Inject(
            method = "method_56689",
            at = @At(
                    value = "TAIL",
                    shift = At.Shift.BEFORE
            ),
            locals = LocalCapture.CAPTURE_FAILEXCEPTION
    )
    private static void buildAttributeValues(
            class_6880<class_1741> armorMaterial,
            class_1738.class_8051 type,
            CallbackInfoReturnable<class_9285> cir,
            int protection, float toughness,
            class_9285.class_9286 builder
    ) {
        for (ThermalResistanceType resistanceType : ThermalResistanceType.values()) {
            resistanceType.buildResistance(armorMaterial, type, builder);
        }
    }

}
