package com.github.thedeathlycow.thermoo.mixin.common;

import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.impl.environment.ThermooBiome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_6880;

@Mixin(class_1959.class)
public class BiomeMixin implements ThermooBiome {
    @Unique
    private final List<class_6880<EnvironmentProvider>> thermoo$environments = new ArrayList<>();

    @Override
    @Unique
    public List<class_6880<EnvironmentProvider>> thermoo$getEnvironmentProviders() {
        return this.thermoo$environments;
    }

    @Override
    public void thermoo$replaceProviders(Collection<class_6880<EnvironmentProvider>> providers) {
        this.thermoo$environments.clear();
        this.thermoo$environments.addAll(providers);
    }
}