package com.github.thedeathlycow.thermoo.mixin.common;

import com.github.thedeathlycow.thermoo.api.ThermooAttributes;
import com.github.thedeathlycow.thermoo.api.ThermooTags;
import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentManager;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingMode;
import com.github.thedeathlycow.thermoo.api.temperature.Soakable;
import com.github.thedeathlycow.thermoo.api.temperature.TemperatureAware;
import com.github.thedeathlycow.thermoo.impl.component.ThermooComponents;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public abstract class EnvironmentAwareEntityMixin extends class_1297 implements TemperatureAware, Soakable {

    @Shadow
    public abstract boolean canBreatheInWater();

    @Shadow
    public abstract double getAttributeValue(class_6880<class_1320> attribute);

    @Shadow
    public abstract boolean hasStatusEffect(class_6880<class_1291> effect);

    public EnvironmentAwareEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Override
    public void thermoo$setWetTicks(int amount) {
        int value = class_3532.method_15340(amount, 0, this.thermoo$getMaxWetTicks());
        ThermooComponents.WETNESS.get(this).setValue(value);
    }

    @Override
    public int thermoo$getWetTicks() {
        return ThermooComponents.WETNESS.get(this).getValue();
    }

    @Override
    public int thermoo$getMaxWetTicks() {
        // base of 600
        int base = EnvironmentManager.INSTANCE.getController().getMaxWetTicks(this);
        double multiplier = this.getAttributeValue(ThermooAttributes.MAX_SOAKING_TICK_MULTIPLIER);
        return class_3532.method_15357(base * multiplier);
    }


    @Override
    public boolean thermoo$ignoresFrigidWater() {
        boolean canBreatheInWater = this.canBreatheInWater()
                || this.hasStatusEffect(class_1294.field_5923)
                || this.hasStatusEffect(class_1294.field_5927);

        return canBreatheInWater && this.method_5869();
    }

    @Override
    public int thermoo$getTemperature() {
        return ThermooComponents.TEMPERATURE.get(this).getValue();
    }

    @Override
    public void thermoo$setTemperature(int temperature) {
        int value = class_3532.method_15340(temperature, this.thermoo$getMinTemperature(), this.thermoo$getMaxTemperature());
        ThermooComponents.TEMPERATURE.get(this).setValue(value);
    }

    @Override
    public int thermoo$getMinTemperature() {
        double minTemp = this.getAttributeValue(ThermooAttributes.MIN_TEMPERATURE);

        return -(int) (minTemp * 140);
    }

    @Override
    public int thermoo$getMaxTemperature() {
        double maxTemp = this.getAttributeValue(ThermooAttributes.MAX_TEMPERATURE);

        return (int) (maxTemp * 140);
    }

    @Override
    public double thermoo$getColdResistance() {
        return this.getAttributeValue(ThermooAttributes.FROST_RESISTANCE);
    }

    @Override
    public double thermoo$getHeatResistance() {
        return this.getAttributeValue(ThermooAttributes.HEAT_RESISTANCE);
    }

    @Override
    public double thermoo$getEnvironmentColdResistance() {
        return this.getAttributeValue(ThermooAttributes.ENVIRONMENT_FROST_RESISTANCE);
    }

    @Override
    public double thermoo$getEnvironmentHeatResistance() {
        return this.getAttributeValue(ThermooAttributes.ENVIRONMENT_HEAT_RESISTANCE);
    }

    @Override
    public boolean thermoo$canFreeze() {

        class_1299<?> type = this.method_5864();

        if (this.method_7325()) {
            return false;
        } else if (type.method_20210(ThermooTags.BENEFITS_FROM_COLD_ENTITY_TYPE)) {
            // entities that benefit from heat override entities that are immune to it
            return true;
        } else if (type.method_20210(ThermooTags.COLD_IMMUNE_ENTITY_TYPE)) {
            return false;
        } else if ((class_1297) this instanceof class_1657 player) {
            return !player.method_7337();
        } else {
            return true;
        }
    }

    @Override
    public boolean thermoo$canOverheat() {
        class_1299<?> type = this.method_5864();

        if (this.method_7325()) {
            return false;
        } else if (type.method_20210(ThermooTags.BENEFITS_FROM_HEAT_ENTITY_TYPE)) {
            // entities that benefit from heat override entities that are immune to it
            return true;
        } else if (type.method_20210(ThermooTags.HEAT_IMMUNE_ENTITY_TYPE)) {
            return false;
        } else if ((class_1297) this instanceof class_1657 player) {
            return !player.method_7337();
        } else {
            return true;
        }
    }

    @Override
    public void thermoo$addTemperature(int temperatureChange, HeatingMode mode) {
        if (temperatureChange == 0) {
            // adding 0 will always do nothing
            return;
        }

        // do not add temperature if immune
        boolean isFreezing = temperatureChange < 0;

        if ((isFreezing && !this.thermoo$canFreeze()) || (!isFreezing && !this.thermoo$canOverheat())) {
            return;
        }

        int currentTemperature = this.thermoo$getTemperature();
        int modifiedChange = mode.applyResistance(this, temperatureChange);
        this.thermoo$setTemperature(currentTemperature + modifiedChange);
    }

    @Override
    public class_5819 thermoo$getRandom() {
        return this.field_5974;
    }

    @Inject(
            method = "createLivingAttributes",
            at = @At("TAIL")
    )
    private static void addThermooAttributesToLivingEntities(CallbackInfoReturnable<class_5132.class_5133> cir) {
        class_5132.class_5133 builder = cir.getReturnValue();

        // register attributes to living entities
        builder.method_26867(ThermooAttributes.MIN_TEMPERATURE);
        builder.method_26867(ThermooAttributes.MAX_TEMPERATURE);
        builder.method_26867(ThermooAttributes.MAX_SOAKING_TICK_MULTIPLIER);
        builder.method_26867(ThermooAttributes.FROST_RESISTANCE);
        builder.method_26867(ThermooAttributes.HEAT_RESISTANCE);
        builder.method_26867(ThermooAttributes.ENVIRONMENT_HEAT_RESISTANCE);
        builder.method_26867(ThermooAttributes.ENVIRONMENT_FROST_RESISTANCE);
    }
}
