package com.github.thedeathlycow.thermoo.mixin.common;

import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentManager;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2248.class)
public class HotFloorMixin {

    @Inject(
            method = "onSteppedOn",
            at = @At("HEAD")
    )
    private void heatEntitiesFromHotFloor(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity, CallbackInfo ci) {

        if (world.field_9236) {
            return;
        }

        if (entity instanceof class_1309 livingEntity) {
            if (livingEntity.method_7325() || livingEntity.method_31481() || livingEntity.method_29504()) {
                return;
            }

            int temperatureChange = EnvironmentManager.INSTANCE.getController().getFloorTemperature(
                    livingEntity,
                    world,
                    state,
                    pos
            );

            if (temperatureChange != 0) {
                livingEntity.thermoo$addTemperature(
                        temperatureChange,
                        HeatingModes.ACTIVE
                );
            }
        }
    }

}
