/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.fabric.mixin;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.fabric.villagerpack.VillagerPackRegistrationFabric;
import com.frikinjay.villagerapi.villagerpack.VillagerPackLoader;
import com.llamalad7.mixinextras.sugar.Local;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_3259;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3283.class})
public class PackRepositoryMixin {
    @Inject(method={"discoverAvailable"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableMap;copyOf(Ljava/util/Map;)Lcom/google/common/collect/ImmutableMap;")})
    private void addExtraPacks(CallbackInfoReturnable<Map<String, class_3288>> cir, @Local Map<String, class_3288> map) {
        for (Path packPath : VillagerPackRegistrationFabric.getDataPackPaths()) {
            String packName = this.getPackName(packPath);
            String packId = "villagerpacks/" + packName.toLowerCase().replace(" ", "_");
            try {
                class_3288 pack = this.createDataPack(packPath, packId, packName);
                if (pack == null) continue;
                map.put(packId, pack);
                VillagerAPI.LOGGER.info("Injected villagerpack as datapack: {}", (Object)packName);
            }
            catch (Exception e) {
                VillagerAPI.LOGGER.error("Failed to inject villagerpack as datapack: {}", (Object)packName, (Object)e);
            }
        }
    }

    @Unique
    private class_3288 createDataPack(Path packPath, String packId, String displayName) {
        VillagerPackLoader.VillagerPack villagerPack = null;
        try {
            villagerPack = new VillagerPackLoader.VillagerPack(packPath);
            Path rootPath = villagerPack.getRootPath();
            class_9224 locationInfo = new class_9224(packId, (class_2561)class_2561.method_43470((String)displayName), class_5352.field_25348, Optional.empty());
            class_9225 selectionConfig = new class_9225(true, class_3288.class_3289.field_14280, false);
            return class_3288.method_45275((class_9224)locationInfo, (class_3288.class_7680)new class_3259.class_8619(rootPath), (class_3264)class_3264.field_14190, (class_9225)selectionConfig);
        }
        catch (IOException e) {
            VillagerAPI.LOGGER.error("Failed to create datapack from villagerpack", (Throwable)e);
            if (villagerPack != null) {
                villagerPack.close();
            }
            return null;
        }
    }

    @Unique
    private String getPackName(Path packPath) {
        String fileName = packPath.getFileName().toString();
        return fileName.endsWith(".zip") ? fileName.replace(".zip", "") : fileName;
    }
}

