/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.fabric.villagerpack;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.platform.CommonPlatformHelper;
import com.frikinjay.villagerapi.villagerpack.VillagerPackHelper;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class VillagerPackRegistrationFabric {
    private static final List<Path> dataPackPaths = new ArrayList<Path>();

    public static void registerPacks() {
        Path villagerPacksDir = CommonPlatformHelper.getGameDirectory().resolve("villagerpacks");
        if (!Files.exists(villagerPacksDir, new LinkOption[0])) {
            VillagerAPI.LOGGER.debug("No villagerpacks directory found at: {}", (Object)villagerPacksDir);
            return;
        }
        VillagerPackRegistrationFabric.registerResourcePacks(villagerPacksDir);
        VillagerPackRegistrationFabric.collectDataPacks(villagerPacksDir);
        VillagerAPI.LOGGER.info("Registered villagerpack repository sources");
    }

    private static void registerResourcePacks(Path villagerPacksDir) {
        try (Stream<Path> packs = Files.list(villagerPacksDir);){
            packs.filter(path -> Files.isDirectory(path, new LinkOption[0]) || Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".zip")).filter(VillagerPackHelper::hasAssets).forEach(packPath -> {
                String packName = VillagerPackRegistrationFabric.getPackName(packPath);
                try {
                    ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)"villagerapi", (String)("villagerpacks_" + packName.toLowerCase().replace(" ", "_"))), (ModContainer)((ModContainer)FabricLoader.getInstance().getModContainer("morevillagers").orElseThrow()), (class_2561)class_2561.method_43470((String)packName), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
                    VillagerAPI.LOGGER.info("Registered villagerpack as resource pack: {}", (Object)packName);
                }
                catch (Exception e) {
                    VillagerAPI.LOGGER.error("Failed to register villagerpack as resource pack: {}", (Object)packName, (Object)e);
                }
            });
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to list villagerpacks for resource packs", (Throwable)e);
        }
    }

    private static void collectDataPacks(Path villagerPacksDir) {
        try (Stream<Path> packs = Files.list(villagerPacksDir);){
            packs.filter(path -> Files.isDirectory(path, new LinkOption[0]) || Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".zip")).filter(VillagerPackHelper::hasData).forEach(packPath -> {
                dataPackPaths.add((Path)packPath);
                VillagerAPI.LOGGER.info("Collected villagerpack for datapack injection: {}", (Object)VillagerPackRegistrationFabric.getPackName(packPath));
            });
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to collect villagerpacks for datapacks", (Throwable)e);
        }
    }

    private static String getPackName(Path packPath) {
        String fileName = packPath.getFileName().toString();
        return fileName.endsWith(".zip") ? fileName.replace(".zip", "") : fileName;
    }

    public static List<Path> getDataPackPaths() {
        return dataPackPaths;
    }
}

