/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.registry;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.mixin.GiveGiftToHeroAccessor;
import com.frikinjay.villagerapi.registry.VAPIProfessions;
import com.frikinjay.villagerapi.villagerpack.VillagerPackCodecs;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_3852;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class VAPIGifts {
    private static final Map<String, LazyGift> DYNAMIC_GIFTS = new HashMap<String, LazyGift>();

    public static void init() {
    }

    public static void registerFromPack(String name, JsonObject json) {
        try {
            VillagerPackCodecs.GiftData giftData = VillagerPackCodecs.parseGift(json);
            LazyGift lazyGift = new LazyGift(name, giftData.profession(), giftData.lootTable());
            DYNAMIC_GIFTS.put(name, lazyGift);
            VillagerAPI.LOGGER.info("Registered gift from pack: {} (will be applied lazily)", (Object)name);
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to register gift from pack: {}", (Object)name, (Object)e);
        }
    }

    public static void applyAllGifts() {
        Map<class_3852, class_5321<class_52>> gifts = GiveGiftToHeroAccessor.getGifts();
        DYNAMIC_GIFTS.values().forEach(lazyGift -> {
            class_3852 profession = lazyGift.resolveProfession();
            if (profession != null) {
                gifts.put(profession, lazyGift.getLootTable());
                VillagerAPI.LOGGER.debug("Applied gift for profession {}", (Object)lazyGift.professionName);
            }
        });
        VillagerAPI.LOGGER.info("Applied {} gifts from packs", (Object)DYNAMIC_GIFTS.size());
    }

    public static Map<String, class_5321<class_52>> getDynamicGifts() {
        HashMap<String, class_5321<class_52>> result = new HashMap<String, class_5321<class_52>>();
        DYNAMIC_GIFTS.forEach((name, lazyGift) -> result.put((String)name, lazyGift.getLootTable()));
        return result;
    }

    private static class LazyGift {
        private final String name;
        private final String professionName;
        private final class_5321<class_52> lootTable;
        private class_3852 cachedProfession;

        public LazyGift(String name, String professionName, class_2960 lootTableId) {
            this.name = name;
            this.professionName = professionName;
            this.lootTable = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)lootTableId);
        }

        public class_5321<class_52> getLootTable() {
            return this.lootTable;
        }

        public class_3852 resolveProfession() {
            if (this.cachedProfession != null) {
                return this.cachedProfession;
            }
            Supplier<class_3852> professionSupplier = VAPIProfessions.getDynamicProfession(this.professionName);
            class_3852 class_38522 = this.cachedProfession = professionSupplier != null ? professionSupplier.get() : (class_3852)class_7923.field_41195.method_10223(class_2960.method_60654((String)this.professionName));
            if (this.cachedProfession == null) {
                VillagerAPI.LOGGER.warn("Profession {} not found for gift {}", (Object)this.professionName, (Object)this.name);
            }
            return this.cachedProfession;
        }
    }
}

