/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.registry;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.mixin.PoiTypesInvoker;
import com.frikinjay.villagerapi.platform.CommonPlatformHelper;
import com.frikinjay.villagerapi.villagerpack.VillagerPackCodecs;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4158;
import net.minecraft.class_7923;

public class VAPIPoiTypes {
    private static final Map<String, Supplier<class_4158>> DYNAMIC_POI_TYPES = new HashMap<String, Supplier<class_4158>>();
    private static final Map<String, class_2960> POI_BLOCK_IDS = new HashMap<String, class_2960>();
    private static final Set<class_2960> PACK_REGISTERED_POI_IDS = new HashSet<class_2960>();

    public static void init() {
    }

    public static class_2960 registerFromPack(String name, JsonObject json) {
        try {
            VillagerPackCodecs.PoiTypeData poiData = VillagerPackCodecs.parsePoiType(json);
            String registryName = name.replace("/", "_");
            String namespace = poiData.namespace() != null ? poiData.namespace() : "villagerapi";
            class_2960 poiId = class_2960.method_60655((String)namespace, (String)registryName);
            POI_BLOCK_IDS.put(name, poiData.block());
            Supplier<class_4158> poiType = CommonPlatformHelper.registerPoiType(namespace, registryName, () -> {
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(poiData.block());
                if (block == null || block == class_2246.field_10124) {
                    VillagerAPI.LOGGER.warn("Block {} not found for POI type {}, using empty block state set", (Object)poiData.block(), (Object)registryName);
                    return Collections.emptySet();
                }
                return PoiTypesInvoker.invokeGetBlockStates(block);
            });
            DYNAMIC_POI_TYPES.put(name, poiType);
            PACK_REGISTERED_POI_IDS.add(poiId);
            VillagerAPI.LOGGER.info("Registered POI type from pack: {} with namespace: {}", (Object)name, (Object)namespace);
            return poiId;
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to register POI type from pack: {}", (Object)name, (Object)e);
            return null;
        }
    }

    public static void validatePoiTypes() {
        int valid = 0;
        int invalid = 0;
        for (Map.Entry<String, class_2960> entry : POI_BLOCK_IDS.entrySet()) {
            String name = entry.getKey();
            class_2960 blockId = entry.getValue();
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(blockId);
            if (block == null || block == class_2246.field_10124) {
                ++invalid;
                VillagerAPI.LOGGER.warn("POI type '{}' references missing block {} - profession will not work", (Object)name, (Object)blockId);
                continue;
            }
            ++valid;
            VillagerAPI.LOGGER.debug("POI type '{}' validated with block {}", (Object)name, (Object)blockId);
        }
        if (valid > 0 || invalid > 0) {
            VillagerAPI.LOGGER.info("POI type validation: {} valid, {} invalid", (Object)valid, (Object)invalid);
        }
    }

    public static boolean isPackRegisteredPoi(class_2960 id) {
        return PACK_REGISTERED_POI_IDS.contains(id);
    }

    public static Supplier<class_4158> getDynamicPoiType(String name) {
        return DYNAMIC_POI_TYPES.get(name);
    }

    public static Map<String, Supplier<class_4158>> getDynamicPoiTypes() {
        return new HashMap<String, Supplier<class_4158>>(DYNAMIC_POI_TYPES);
    }
}

