/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.registry;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.platform.CommonPlatformHelper;
import com.frikinjay.villagerapi.registry.VAPIPoiTypes;
import com.frikinjay.villagerapi.villagerpack.VillagerPackCodecs;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3852;
import net.minecraft.class_4158;
import net.minecraft.class_7923;

public class VAPIProfessions {
    private static final Map<String, Supplier<class_3852>> DYNAMIC_PROFESSIONS = new HashMap<String, Supplier<class_3852>>();
    private static final Map<String, ProfessionInfo> PROFESSION_DATA = new HashMap<String, ProfessionInfo>();

    public static void init() {
    }

    public static void registerFromPack(String name, JsonObject json) {
        try {
            VillagerPackCodecs.ProfessionData profData = VillagerPackCodecs.parseProfession(json);
            String registryName = name.replace("/", "_");
            String namespace = profData.namespace() != null ? profData.namespace() : "villagerapi";
            PROFESSION_DATA.put(name, new ProfessionInfo(registryName, namespace, profData.poiType(), profData.workSound()));
            Supplier<class_3852> profession = CommonPlatformHelper.registerProfession(namespace, registryName, () -> {
                Supplier<class_4158> poiTypeSupplier = VAPIPoiTypes.getDynamicPoiType(profData.poiType());
                if (poiTypeSupplier == null) {
                    VillagerAPI.LOGGER.warn("POI type {} not found for profession {}. Profession will not function.", (Object)profData.poiType(), (Object)registryName);
                    return new class_3852(registryName, holder -> false, holder -> false, ImmutableSet.of(), ImmutableSet.of(), class_3417.field_20669);
                }
                class_3414 workSound = (class_3414)class_7923.field_41172.method_10223(profData.workSound());
                if (workSound == null) {
                    VillagerAPI.LOGGER.warn("Sound event {} not found for profession {}, using default", (Object)profData.workSound(), (Object)registryName);
                    workSound = class_3417.field_20669;
                }
                return new class_3852(registryName, holder -> ((class_4158)holder.comp_349()).equals(poiTypeSupplier.get()), holder -> ((class_4158)holder.comp_349()).equals(poiTypeSupplier.get()), ImmutableSet.of(), ImmutableSet.of(), workSound);
            });
            DYNAMIC_PROFESSIONS.put(name, profession);
            VillagerAPI.LOGGER.info("Registered profession from pack: {}", (Object)name);
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to register profession from pack: {}", (Object)name, (Object)e);
        }
    }

    public static void validateProfessions() {
        int valid = 0;
        int invalid = 0;
        for (Map.Entry<String, ProfessionInfo> entry : PROFESSION_DATA.entrySet()) {
            String name = entry.getKey();
            ProfessionInfo data = entry.getValue();
            Supplier<class_4158> poiType = VAPIPoiTypes.getDynamicPoiType(data.poiTypeName);
            if (poiType == null) {
                ++invalid;
                VillagerAPI.LOGGER.warn("Profession '{}' references missing POI type '{}' - will not function", (Object)name, (Object)data.poiTypeName);
                continue;
            }
            ++valid;
            VillagerAPI.LOGGER.debug("Profession '{}' validated with POI type '{}'", (Object)name, (Object)data.poiTypeName);
        }
        if (valid > 0 || invalid > 0) {
            VillagerAPI.LOGGER.info("Profession validation: {} valid, {} invalid", (Object)valid, (Object)invalid);
        }
    }

    public static Supplier<class_3852> getDynamicProfession(String name) {
        return DYNAMIC_PROFESSIONS.get(name);
    }

    public static Map<String, Supplier<class_3852>> getDynamicProfessions() {
        return new HashMap<String, Supplier<class_3852>>(DYNAMIC_PROFESSIONS);
    }

    private static class ProfessionInfo {
        final String registryName;
        final String namespace;
        final String poiTypeName;
        final class_2960 workSoundId;

        ProfessionInfo(String registryName, String namespace, String poiTypeName, class_2960 workSoundId) {
            this.registryName = registryName;
            this.namespace = namespace;
            this.poiTypeName = poiTypeName;
            this.workSoundId = workSoundId;
        }
    }
}

