/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.registry;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.platform.CommonPlatformHelper;
import com.frikinjay.villagerapi.villagerpack.VillagerPackCodecs;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_3854;

public class VAPITypes {
    private static final Map<String, Supplier<class_3854>> DYNAMIC_TYPES = new HashMap<String, Supplier<class_3854>>();

    public static void init() {
    }

    public static void registerFromPack(String name, JsonObject json) {
        try {
            VillagerPackCodecs.VillagerTypeData typeData = VillagerPackCodecs.parseVillagerType(json);
            String registryName = name.replace("/", "_");
            String namespace = typeData.namespace() != null ? typeData.namespace() : "villagerapi";
            Supplier<class_3854> type = CommonPlatformHelper.registerVillagerType(namespace, registryName, () -> new class_3854(typeData.name()));
            DYNAMIC_TYPES.put(name, type);
            VillagerAPI.LOGGER.info("Registered villager type from pack: {}", (Object)name);
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to register villager type from pack: {}", (Object)name, (Object)e);
        }
    }

    public static Supplier<class_3854> getDynamicType(String name) {
        return DYNAMIC_TYPES.get(name);
    }

    public static Map<String, Supplier<class_3854>> getDynamicTypes() {
        return new HashMap<String, Supplier<class_3854>>(DYNAMIC_TYPES);
    }
}

