/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.villagerpack;

import com.frikinjay.villagerapi.VillagerAPI;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3854;

public class BiomeTradesCache {
    private static final Map<class_3852, Map<class_3854, Int2ObjectMap<class_3853.class_1652[]>>> BIOME_TRADES_CACHE = new HashMap<class_3852, Map<class_3854, Int2ObjectMap<class_3853.class_1652[]>>>();
    private static final Map<class_3852, Map<class_3854, Map<Integer, Boolean>>> REPLACE_FLAGS = new HashMap<class_3852, Map<class_3854, Map<Integer, Boolean>>>();

    public static void registerBiomeTrades(class_3852 profession, class_3854 villagerType, Int2ObjectMap<class_3853.class_1652[]> trades) {
        BIOME_TRADES_CACHE.computeIfAbsent(profession, k -> new HashMap()).put(villagerType, trades);
        VillagerAPI.LOGGER.debug("Registered biome trades for profession {} in biome type {}", (Object)profession, (Object)villagerType);
    }

    public static Int2ObjectMap<class_3853.class_1652[]> getBiomeTrades(class_3852 profession, class_3854 villagerType) {
        Map<class_3854, Int2ObjectMap<class_3853.class_1652[]>> professionTrades = BIOME_TRADES_CACHE.get(profession);
        if (professionTrades == null) {
            return null;
        }
        return professionTrades.get(villagerType);
    }

    public static boolean hasBiomeTrades(class_3852 profession) {
        return BIOME_TRADES_CACHE.containsKey(profession);
    }

    public static void registerReplaceFlag(class_3852 profession, class_3854 villagerType, int level, boolean replace) {
        REPLACE_FLAGS.computeIfAbsent(profession, k -> new HashMap()).computeIfAbsent(villagerType, k -> new HashMap()).put(level, replace);
    }

    private static boolean shouldReplace(class_3852 profession, class_3854 villagerType, int level) {
        Map<class_3854, Map<Integer, Boolean>> professionFlags = REPLACE_FLAGS.get(profession);
        if (professionFlags == null) {
            return false;
        }
        Map<Integer, Boolean> typeFlags = professionFlags.get(villagerType);
        if (typeFlags == null) {
            return false;
        }
        return typeFlags.getOrDefault(level, false);
    }

    public static Int2ObjectMap<class_3853.class_1652[]> getMergedTrades(class_3852 profession, class_3854 villagerType) {
        Int2ObjectMap baseTrades = (Int2ObjectMap)class_3853.field_17067.get(profession);
        if (baseTrades == null) {
            return null;
        }
        Int2ObjectMap<class_3853.class_1652[]> biomeTrades = BiomeTradesCache.getBiomeTrades(profession, villagerType);
        if (biomeTrades == null) {
            return baseTrades;
        }
        Int2ObjectOpenHashMap mergedTrades = new Int2ObjectOpenHashMap();
        baseTrades.int2ObjectEntrySet().forEach(arg_0 -> BiomeTradesCache.lambda$getMergedTrades$3((Int2ObjectMap)mergedTrades, arg_0));
        biomeTrades.int2ObjectEntrySet().forEach(arg_0 -> BiomeTradesCache.lambda$getMergedTrades$4(profession, villagerType, (Int2ObjectMap)mergedTrades, arg_0));
        return mergedTrades;
    }

    public static void clear() {
        BIOME_TRADES_CACHE.clear();
        REPLACE_FLAGS.clear();
        VillagerAPI.LOGGER.debug("Cleared biome trades cache");
    }

    private static /* synthetic */ void lambda$getMergedTrades$4(class_3852 profession, class_3854 villagerType, Int2ObjectMap mergedTrades, Int2ObjectMap.Entry entry) {
        int level = entry.getIntKey();
        class_3853.class_1652[] biomeListings = (class_3853.class_1652[])entry.getValue();
        if (BiomeTradesCache.shouldReplace(profession, villagerType, level)) {
            mergedTrades.put(level, (Object)biomeListings);
            VillagerAPI.LOGGER.debug("Replaced trades for profession {} biome {} level {} (replace mode)", new Object[]{profession, villagerType, level});
        } else if (mergedTrades.containsKey(level)) {
            class_3853.class_1652[] baseListings = (class_3853.class_1652[])mergedTrades.get(level);
            class_3853.class_1652[] combined = new class_3853.class_1652[baseListings.length + biomeListings.length];
            System.arraycopy(baseListings, 0, combined, 0, baseListings.length);
            System.arraycopy(biomeListings, 0, combined, baseListings.length, biomeListings.length);
            mergedTrades.put(level, (Object)combined);
            VillagerAPI.LOGGER.debug("Merged trades for profession {} biome {} level {} (add mode)", new Object[]{profession, villagerType, level});
        } else {
            mergedTrades.put(level, (Object)biomeListings);
        }
    }

    private static /* synthetic */ void lambda$getMergedTrades$3(Int2ObjectMap mergedTrades, Int2ObjectMap.Entry entry) {
        mergedTrades.put(entry.getIntKey(), (Object)((class_3853.class_1652[])((class_3853.class_1652[])entry.getValue()).clone()));
    }
}

