/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.villagerpack;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.villagerpack.BiomeMappingCache;
import com.frikinjay.villagerapi.villagerpack.BiomeTradesCache;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3854;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class VillagerPackBiomeMapper {
    public static void registerBiomeMappings(Map<String, JsonObject> data, MinecraftServer server) {
        if (data.isEmpty()) {
            VillagerAPI.LOGGER.debug("No biome mappings to register");
            return;
        }
        BiomeMappingCache.clear();
        BiomeTradesCache.clear();
        class_2378 villagerTypeRegistry = (class_2378)server.method_30611().method_33310(class_7924.field_41235).orElseThrow();
        int registered = 0;
        for (Map.Entry<String, JsonObject> entry : data.entrySet()) {
            try {
                JsonObject mappings = entry.getValue();
                if (!mappings.has("biomes")) {
                    VillagerAPI.LOGGER.warn("Biome mapping file {} has no 'biomes' field", (Object)entry.getKey());
                    continue;
                }
                JsonObject biomes = mappings.getAsJsonObject("biomes");
                for (String biomeKey : biomes.keySet()) {
                    String villagerTypeId = biomes.get(biomeKey).getAsString();
                    class_5321 biomeResourceKey = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60654((String)biomeKey));
                    class_3854 villagerType = (class_3854)villagerTypeRegistry.method_10223(class_2960.method_60654((String)villagerTypeId));
                    if (villagerType == null) {
                        VillagerAPI.LOGGER.warn("Villager type {} not found for biome mapping", (Object)villagerTypeId);
                        continue;
                    }
                    BiomeMappingCache.registerMapping((class_5321<class_1959>)biomeResourceKey, villagerType);
                    ++registered;
                    VillagerAPI.LOGGER.debug("Mapped biome {} to villager type {}", (Object)biomeKey, (Object)villagerTypeId);
                }
            }
            catch (Exception e) {
                VillagerAPI.LOGGER.error("Failed to process biome mapping: {}", (Object)entry.getKey(), (Object)e);
            }
        }
        VillagerAPI.LOGGER.info("Registered {} biome-to-villager-type mappings from villagerpacks", (Object)registered);
    }
}

