/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.villagerpack;

import com.frikinjay.villagerapi.VillagerAPI;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_2179;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3853;
import net.minecraft.class_3854;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9306;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9329;

public class VillagerPackCodecs {
    private static class_7225.class_7874 registryLookup = null;

    public static void setRegistryLookup(class_7225.class_7874 lookup) {
        registryLookup = lookup;
    }

    public static ProfessionData parseProfession(JsonObject json) {
        String poiType = json.get("poi_type").getAsString();
        String workSound = json.get("work_sound").getAsString();
        String namespace = json.get("namespace").getAsString();
        return new ProfessionData(poiType, class_2960.method_60654((String)workSound), namespace);
    }

    public static PoiTypeData parsePoiType(JsonObject json) {
        String block = json.get("block").getAsString();
        int tickets = json.has("tickets") ? json.get("tickets").getAsInt() : 1;
        String namespace = json.has("namespace") ? json.get("namespace").getAsString() : "villagerapi";
        return new PoiTypeData(class_2960.method_60654((String)block), tickets, namespace);
    }

    public static VillagerTypeData parseVillagerType(JsonObject json) {
        String name = json.get("name").getAsString();
        String namespace = json.has("namespace") ? json.get("namespace").getAsString() : "villagerapi";
        return new VillagerTypeData(name, namespace);
    }

    public static GiftData parseGift(JsonObject json) {
        String profession = json.get("profession").getAsString();
        String lootTable = json.get("loot_table").getAsString();
        return new GiftData(profession, class_2960.method_60654((String)lootTable));
    }

    public static TradesData parseTrades(JsonObject json) {
        String profession = json.get("profession").getAsString();
        JsonObject levelsObj = json.getAsJsonObject("levels");
        Int2ObjectOpenHashMap trades = new Int2ObjectOpenHashMap();
        for (String levelStr : levelsObj.keySet()) {
            int level = Integer.parseInt(levelStr);
            JsonArray tradesArray = levelsObj.getAsJsonArray(levelStr);
            ArrayList<class_3853.class_1652> listings = new ArrayList<class_3853.class_1652>();
            for (JsonElement tradeElement : tradesArray) {
                JsonObject tradeObj = tradeElement.getAsJsonObject();
                class_3853.class_1652 listing = VillagerPackCodecs.parseTrade(tradeObj);
                if (listing == null) continue;
                listings.add(listing);
            }
            trades.put(level, (Object)listings.toArray(new class_3853.class_1652[0]));
        }
        return new TradesData(profession, (Int2ObjectMap<class_3853.class_1652[]>)trades);
    }

    public static BiomeTradesData parseBiomeTrades(JsonObject json) {
        String profession = json.get("profession").getAsString();
        JsonObject biomeOverrides = json.getAsJsonObject("biome_overrides");
        HashMap<class_3854, Int2ObjectMap<class_3853.class_1652[]>> biomeTradeMap = new HashMap<class_3854, Int2ObjectMap<class_3853.class_1652[]>>();
        HashMap<class_3854, Map<Integer, Boolean>> replaceFlags = new HashMap<class_3854, Map<Integer, Boolean>>();
        for (String biomeTypeKey : biomeOverrides.keySet()) {
            class_3854 villagerType = (class_3854)class_7923.field_41194.method_10223(class_2960.method_60654((String)biomeTypeKey));
            if (villagerType == null) {
                VillagerAPI.LOGGER.warn("Unknown villager type: {}", (Object)biomeTypeKey);
                continue;
            }
            JsonObject biomeData = biomeOverrides.getAsJsonObject(biomeTypeKey);
            JsonObject levelsObj = biomeData.getAsJsonObject("levels");
            Int2ObjectOpenHashMap trades = new Int2ObjectOpenHashMap();
            HashMap<Integer, Boolean> levelReplaceFlags = new HashMap<Integer, Boolean>();
            for (String levelStr : levelsObj.keySet()) {
                JsonArray tradesArray;
                int level = Integer.parseInt(levelStr);
                JsonElement levelElement = levelsObj.get(levelStr);
                boolean replace = false;
                if (levelElement.isJsonArray()) {
                    tradesArray = levelElement.getAsJsonArray();
                } else if (levelElement.isJsonObject()) {
                    JsonObject levelObj = levelElement.getAsJsonObject();
                    replace = levelObj.has("replace") && levelObj.get("replace").getAsBoolean();
                    tradesArray = levelObj.getAsJsonArray("trades");
                } else {
                    VillagerAPI.LOGGER.warn("Invalid level data format for level {} in biome {}", (Object)levelStr, (Object)biomeTypeKey);
                    continue;
                }
                ArrayList<class_3853.class_1652> listings = new ArrayList<class_3853.class_1652>();
                for (JsonElement tradeElement : tradesArray) {
                    JsonObject tradeObj = tradeElement.getAsJsonObject();
                    class_3853.class_1652 listing = VillagerPackCodecs.parseTrade(tradeObj);
                    if (listing == null) continue;
                    listings.add(listing);
                }
                trades.put(level, (Object)listings.toArray(new class_3853.class_1652[0]));
                levelReplaceFlags.put(level, replace);
            }
            biomeTradeMap.put(villagerType, (Int2ObjectMap<class_3853.class_1652[]>)trades);
            replaceFlags.put(villagerType, levelReplaceFlags);
        }
        return new BiomeTradesData(profession, biomeTradeMap, replaceFlags);
    }

    private static class_3853.class_1652 parseTrade(JsonObject json) {
        try {
            JsonElement sellElement = json.get("sell");
            if (sellElement != null && sellElement.isJsonObject()) {
                String itemType;
                JsonObject sellObj = sellElement.getAsJsonObject();
                String string = itemType = sellObj.has("item_type") ? sellObj.get("item_type").getAsString() : "simple";
                if ("treasure_map".equals(itemType)) {
                    return VillagerPackCodecs.parseTreasureMapTrade(json, sellObj);
                }
            }
            return VillagerPackCodecs.parseSimpleTrade(json);
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to parse trade: {}", (Object)json, (Object)e);
            return null;
        }
    }

    private static class_3853.class_1652 parseSimpleTrade(JsonObject json) {
        LazyItemStack buyA = VillagerPackCodecs.parseLazyItemStack(json.get("buy_a"));
        LazyItemStack buyB = json.has("buy_b") ? VillagerPackCodecs.parseLazyItemStack(json.get("buy_b")) : null;
        LazyItemStack sell = VillagerPackCodecs.parseLazyItemStack(json.get("sell"));
        int maxUses = json.has("max_uses") ? json.get("max_uses").getAsInt() : 16;
        int xp = json.has("xp") ? json.get("xp").getAsInt() : 1;
        float priceMultiplier = json.has("price_multiplier") ? json.get("price_multiplier").getAsFloat() : 0.05f;
        return (trader, random) -> {
            class_1799 buyAStack = buyA.resolve();
            class_1799 buyBStack = buyB != null ? buyB.resolve() : class_1799.field_8037;
            class_1799 sellStack = sell.resolve();
            if (buyAStack.method_7960() || sellStack.method_7960()) {
                return null;
            }
            class_9306 costA = new class_9306(buyAStack.method_41409(), buyAStack.method_7947(), class_9329.method_57865((class_9323)buyAStack.method_57353()));
            Optional costB = buyBStack.method_7960() ? Optional.empty() : Optional.of(new class_9306(buyBStack.method_41409(), buyBStack.method_7947(), class_9329.method_57865((class_9323)buyBStack.method_57353())));
            return new class_1914(costA, costB, sellStack.method_7972(), maxUses, xp, priceMultiplier);
        };
    }

    private static class_3853.class_1652 parseTreasureMapTrade(JsonObject json, JsonObject sellObj) {
        LazyItemStack buyA = VillagerPackCodecs.parseLazyItemStack(json.get("buy_a"));
        LazyItemStack buyB = json.has("buy_b") ? VillagerPackCodecs.parseLazyItemStack(json.get("buy_b")) : null;
        String structureTag = sellObj.get("structure_tag").getAsString();
        String displayName = sellObj.get("display_name").getAsString();
        String mapDecoration = sellObj.get("map_decoration").getAsString();
        int maxUses = json.has("max_uses") ? json.get("max_uses").getAsInt() : 12;
        int xp = json.has("xp") ? json.get("xp").getAsInt() : 5;
        class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60654((String)structureTag));
        class_5321 decorationKey = class_5321.method_29179((class_5321)class_7924.field_50082, (class_2960)class_2960.method_60654((String)mapDecoration));
        return (trader, random) -> {
            class_1799 buyBStack;
            class_1799 buyAStack = buyA.resolve();
            class_1799 class_17992 = buyBStack = buyB != null ? buyB.resolve() : class_1799.field_8037;
            if (buyAStack.method_7960()) {
                return null;
            }
            class_6880 decoration = class_7923.field_50078.method_40264(decorationKey).orElse(null);
            if (decoration == null) {
                VillagerAPI.LOGGER.warn("Unknown map decoration: {}", (Object)mapDecoration);
                return null;
            }
            if (buyAStack.method_31574(class_1802.field_8687) && buyBStack.method_7960()) {
                int emeraldCost = buyAStack.method_7947();
                class_3853.class_1654 mapTrade = new class_3853.class_1654(emeraldCost, tag, displayName, decoration, maxUses, xp);
                return mapTrade.method_7246(trader, random);
            }
            class_3853.class_1654 mapTrade = new class_3853.class_1654(1, tag, displayName, decoration, maxUses, xp);
            class_1914 mapOffer = mapTrade.method_7246(trader, random);
            if (mapOffer == null) {
                return null;
            }
            class_9306 costA = new class_9306(buyAStack.method_41409(), buyAStack.method_7947(), class_9329.method_57865((class_9323)buyAStack.method_57353()));
            Optional costB = buyBStack.method_7960() ? Optional.empty() : Optional.of(new class_9306(buyBStack.method_41409(), buyBStack.method_7947(), class_9329.method_57865((class_9323)buyBStack.method_57353())));
            return new class_1914(costA, costB, mapOffer.method_8250(), maxUses, xp, 0.05f);
        };
    }

    private static LazyItemStack parseLazyItemStack(JsonElement element) {
        if (element.isJsonPrimitive()) {
            return new LazyItemStack(element.getAsString(), 1, null);
        }
        JsonObject obj = element.getAsJsonObject();
        String itemId = obj.get("item").getAsString();
        int count = obj.has("count") ? obj.get("count").getAsInt() : 1;
        JsonObject components = obj.has("components") ? obj.getAsJsonObject("components") : null;
        return new LazyItemStack(itemId, count, components);
    }

    private static class_1799 parseItemStack(JsonElement element) {
        return VillagerPackCodecs.parseLazyItemStack(element).resolve();
    }

    private static void applyComponentData(class_1799 stack, JsonObject componentsObj) {
        if (registryLookup == null) {
            VillagerAPI.LOGGER.error("Registry lookup not available for component parsing");
            return;
        }
        try {
            class_2487 componentsTag = new class_2487();
            for (String key : componentsObj.keySet()) {
                JsonElement value = componentsObj.get(key);
                if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isNumber()) {
                    componentsTag.method_10569(key, value.getAsInt());
                    continue;
                }
                if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isString()) {
                    componentsTag.method_10582(key, value.getAsString());
                    continue;
                }
                if (value.isJsonObject()) {
                    componentsTag.method_10566(key, (class_2520)VillagerPackCodecs.jsonObjectToNbt(value.getAsJsonObject()));
                    continue;
                }
                String valueStr = value.toString();
                try {
                    class_2487 parsedValue = class_2179.method_9284().method_9286(new StringReader(valueStr));
                    componentsTag.method_10566(key, (class_2520)parsedValue);
                }
                catch (CommandSyntaxException e) {
                    VillagerAPI.LOGGER.error("Failed to parse component value for '{}': {}", new Object[]{key, valueStr, e});
                }
            }
            class_6903 registryOps = registryLookup.method_57093((DynamicOps)class_2509.field_11560);
            class_9326 patch = class_9326.field_49589.parse((DynamicOps)registryOps, (Object)componentsTag).resultOrPartial(error -> VillagerAPI.LOGGER.error("Failed to parse components: {}", error)).orElse(class_9326.field_49588);
            stack.method_57366(patch);
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to apply component data: {}", (Object)componentsObj, (Object)e);
        }
    }

    private static class_2487 jsonObjectToNbt(JsonObject json) {
        class_2487 tag = new class_2487();
        for (String key : json.keySet()) {
            JsonElement value = json.get(key);
            tag.method_10566(key, VillagerPackCodecs.jsonElementToNbt(value));
        }
        return tag;
    }

    private static class_2520 jsonElementToNbt(JsonElement element) {
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return class_2497.method_23247((int)primitive.getAsInt());
            }
            if (primitive.isString()) {
                return class_2519.method_23256((String)primitive.getAsString());
            }
            if (primitive.isBoolean()) {
                return class_2481.method_23234((boolean)primitive.getAsBoolean());
            }
        } else {
            if (element.isJsonObject()) {
                return VillagerPackCodecs.jsonObjectToNbt(element.getAsJsonObject());
            }
            if (element.isJsonArray()) {
                JsonArray array = element.getAsJsonArray();
                class_2499 list = new class_2499();
                for (JsonElement item : array) {
                    list.add((Object)VillagerPackCodecs.jsonElementToNbt(item));
                }
                return list;
            }
        }
        return class_2519.method_23256((String)element.toString());
    }

    public record ProfessionData(String poiType, class_2960 workSound, String namespace) {
    }

    public record PoiTypeData(class_2960 block, int tickets, String namespace) {
    }

    public record VillagerTypeData(String name, String namespace) {
    }

    public record GiftData(String profession, class_2960 lootTable) {
    }

    public record TradesData(String profession, Int2ObjectMap<class_3853.class_1652[]> trades) {
    }

    public record BiomeTradesData(String profession, Map<class_3854, Int2ObjectMap<class_3853.class_1652[]>> biomeTradeMap, Map<class_3854, Map<Integer, Boolean>> replaceFlags) {
    }

    private static class LazyItemStack {
        private final String itemId;
        private final int count;
        private final JsonObject components;
        private class_1799 cached;

        public LazyItemStack(String itemId, int count, JsonObject components) {
            this.itemId = itemId;
            this.count = count;
            this.components = components;
        }

        public class_1799 resolve() {
            if (this.cached != null) {
                return this.cached;
            }
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)this.itemId));
            if (item == null || item == class_1802.field_8162) {
                VillagerAPI.LOGGER.warn("Item {} not found, using AIR", (Object)this.itemId);
                this.cached = class_1799.field_8037;
                return this.cached;
            }
            this.cached = new class_1799((class_1935)item, this.count);
            if (this.components != null) {
                VillagerPackCodecs.applyComponentData(this.cached, this.components);
            }
            return this.cached;
        }
    }
}

