/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.villagerpack;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.platform.CommonPlatformHelper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VillagerPackLoader {
    private final Path villagerPacksDir;

    public VillagerPackLoader(Path gameDirectory) {
        this.villagerPacksDir = gameDirectory.resolve("villagerpacks");
        this.ensureDirectoryExists();
    }

    private void ensureDirectoryExists() {
        try {
            if (!Files.exists(this.villagerPacksDir, new LinkOption[0])) {
                Files.createDirectories(this.villagerPacksDir, new FileAttribute[0]);
                VillagerAPI.LOGGER.info("Created villagerpacks directory at: {}", (Object)this.villagerPacksDir);
            }
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to create villagerpacks directory", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DataType, Map<String, JsonObject>> loadAllPacks() {
        EnumMap<DataType, Map<String, JsonObject>> allData = new EnumMap<DataType, Map<String, JsonObject>>(DataType.class);
        for (DataType type : DataType.values()) {
            allData.put(type, new LinkedHashMap());
        }
        try {
            List<VillagerPack> packs = this.discoverPacks();
            VillagerAPI.LOGGER.info("Found {} villager pack(s)", (Object)packs.size());
            try {
                for (VillagerPack pack : packs) {
                    if (pack.isValid()) {
                        this.loadPackData(pack, allData);
                        continue;
                    }
                    VillagerAPI.LOGGER.warn("Skipping invalid pack: {}", (Object)pack.getName());
                }
            }
            finally {
                for (VillagerPack pack : packs) {
                    pack.close();
                }
            }
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to load villager packs", (Throwable)e);
        }
        return allData;
    }

    private List<VillagerPack> discoverPacks() throws Exception {
        if (!Files.exists(this.villagerPacksDir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try (Stream<Path> paths = Files.list(this.villagerPacksDir);){
            Stream<Path> additionalPaths = Files.list(CommonPlatformHelper.getGameDirectory().resolve("mods"));
            List<VillagerPack> list = Stream.concat(additionalPaths, paths).filter(path -> Files.isDirectory(path, new LinkOption[0]) || Files.isRegularFile(path, new LinkOption[0]) && (path.toString().endsWith(".zip") || path.toString().endsWith(".jar"))).map(path -> {
                try {
                    return new VillagerPack((Path)path);
                }
                catch (IOException e) {
                    VillagerAPI.LOGGER.error("Failed to load pack: {}", path, (Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).sorted(Comparator.comparing(VillagerPack::getName)).collect(Collectors.toList());
            return list;
        }
    }

    private void loadPackData(VillagerPack pack, Map<DataType, Map<String, JsonObject>> allData) {
        VillagerAPI.LOGGER.info("Loading villager pack: {}", (Object)pack.getName());
        for (DataType type : DataType.values()) {
            Path typeDir = pack.getRootPath().resolve("villagers").resolve(type.getPath());
            if (!Files.exists(typeDir, new LinkOption[0])) continue;
            try (Stream<Path> files = Files.walk(typeDir, new FileVisitOption[0]);){
                files.filter(p -> p.toString().endsWith(".json")).forEach(file -> {
                    try {
                        String fileName = typeDir.relativize((Path)file).toString().replace(".json", "").replace(File.separator, "/");
                        JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(Files.newInputStream(file, new OpenOption[0]))).getAsJsonObject();
                        ((Map)allData.get((Object)type)).put(fileName, json);
                        VillagerAPI.LOGGER.debug("Loaded {} from pack {}: {}", new Object[]{type.name(), pack.getName(), fileName});
                    }
                    catch (Exception e) {
                        VillagerAPI.LOGGER.error("Failed to load file: {}", file, (Object)e);
                    }
                });
            }
            catch (Exception e) {
                VillagerAPI.LOGGER.error("Failed to read {} directory in pack {}", new Object[]{type.getPath(), pack.getName(), e});
            }
        }
    }

    public List<VillagerPack> getDiscoveredPacks() {
        try {
            return this.discoverPacks();
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to discover packs", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static enum DataType {
        POI_TYPES("poi_types"),
        TYPES("types"),
        PROFESSIONS("professions"),
        TRADES("trades"),
        GIFTS("gifts"),
        BIOME_TRADES("biome_trades"),
        HERO_GIFTS("hero_of_the_village"),
        BIOME_MAPPINGS("biome_mappings");

        private final String path;

        private DataType(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }

    public static class VillagerPack
    implements AutoCloseable {
        private final Path sourcePath;
        private final String name;
        private final FileSystem zipFileSystem;
        private final Path rootPath;
        private final boolean ownsFileSystem;
        private JsonObject packMeta;

        public VillagerPack(Path path) throws IOException {
            this.sourcePath = path;
            if (Files.isDirectory(path, new LinkOption[0])) {
                this.name = path.getFileName().toString();
                this.zipFileSystem = null;
                this.rootPath = path;
                this.ownsFileSystem = false;
            } else if (path.toString().endsWith(".zip") || path.toString().endsWith(".jar")) {
                FileSystem fs;
                this.name = path.getFileName().toString().substring(0, path.getFileName().toString().length() - 4);
                URI uri = URI.create("jar:" + String.valueOf(path.toUri()));
                boolean created = false;
                try {
                    fs = FileSystems.getFileSystem(uri);
                }
                catch (FileSystemNotFoundException e) {
                    fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    created = true;
                }
                this.zipFileSystem = fs;
                this.rootPath = this.zipFileSystem.getPath("/", new String[0]);
                this.ownsFileSystem = created;
            } else {
                throw new IOException("Unsupported pack format: " + String.valueOf(path));
            }
            this.loadPackMeta();
        }

        private void loadPackMeta() {
            Path metaFile = this.rootPath.resolve("pack.mcmeta");
            if (Files.exists(metaFile, new LinkOption[0])) {
                try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(metaFile, new OpenOption[0]));){
                    this.packMeta = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                }
                catch (Exception e) {
                    VillagerAPI.LOGGER.warn("Failed to load pack.mcmeta for pack: {}", (Object)this.name, (Object)e);
                }
            }
        }

        public boolean isValid() {
            return this.packMeta != null || Files.exists(this.rootPath.resolve("villagers"), new LinkOption[0]);
        }

        public boolean hasAssets() {
            return Files.exists(this.rootPath.resolve("assets"), new LinkOption[0]);
        }

        public boolean hasData() {
            return Files.exists(this.rootPath.resolve("data"), new LinkOption[0]);
        }

        public Path getPath() {
            return this.sourcePath;
        }

        public Path getRootPath() {
            return this.rootPath;
        }

        public String getName() {
            return this.name;
        }

        public JsonObject getPackMeta() {
            return this.packMeta;
        }

        public Path getIconPath() {
            Path iconPath = this.rootPath.resolve("pack.png");
            return Files.exists(iconPath, new LinkOption[0]) ? iconPath : null;
        }

        public boolean isZipPack() {
            return this.zipFileSystem != null;
        }

        @Override
        public void close() {
            if (this.zipFileSystem != null && this.ownsFileSystem) {
                try {
                    this.zipFileSystem.close();
                }
                catch (IOException e) {
                    VillagerAPI.LOGGER.error("Failed to close zip filesystem for pack: {}", (Object)this.name, (Object)e);
                }
            }
        }
    }
}

