/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.villagerpack;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.registry.VAPIGifts;
import com.frikinjay.villagerapi.registry.VAPIPoiTypes;
import com.frikinjay.villagerapi.registry.VAPIProfessions;
import com.frikinjay.villagerapi.registry.VAPITypes;
import com.frikinjay.villagerapi.villagerpack.BiomeTradesCache;
import com.frikinjay.villagerapi.villagerpack.VillagerPackCodecs;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class VillagerPackRegistry {
    public static void registerVillagerTypes(Map<String, JsonObject> data) {
        if (data.isEmpty()) {
            return;
        }
        VillagerAPI.LOGGER.info("Registering {} villager types from packs", (Object)data.size());
        data.forEach((name, json) -> VAPITypes.registerFromPack(name, json));
    }

    public static void registerPoiTypes(Map<String, JsonObject> data) {
        if (data.isEmpty()) {
            return;
        }
        VillagerAPI.LOGGER.info("Registering {} POI types from packs", (Object)data.size());
        data.forEach((name, json) -> VAPIPoiTypes.registerFromPack(name, json));
    }

    public static void registerProfessions(Map<String, JsonObject> data) {
        if (data.isEmpty()) {
            return;
        }
        VillagerAPI.LOGGER.info("Registering {} professions from packs", (Object)data.size());
        data.forEach((name, json) -> VAPIProfessions.registerFromPack(name, json));
    }

    public static void validateRegistrations() {
        VillagerAPI.LOGGER.info("Validating POI types and professions...");
        VAPIPoiTypes.validatePoiTypes();
        VAPIProfessions.validateProfessions();
    }

    public static void registerTrades(Map<String, JsonObject> data) {
        VillagerPackRegistry.registerTrades(data, null);
    }

    public static void registerTrades(Map<String, JsonObject> data, class_7225.class_7874 registryLookup) {
        if (data.isEmpty()) {
            return;
        }
        VillagerAPI.LOGGER.info("Registering trades for {} professions from packs", (Object)data.size());
        VillagerPackCodecs.setRegistryLookup(registryLookup);
        data.forEach((name, json) -> {
            try {
                class_3852 prof;
                VillagerPackCodecs.TradesData tradesData = VillagerPackCodecs.parseTrades(json);
                Supplier<class_3852> professionSupplier = VAPIProfessions.getDynamicProfession(tradesData.profession());
                class_3852 class_38522 = prof = professionSupplier != null ? professionSupplier.get() : (class_3852)class_7923.field_41195.method_10223(class_2960.method_60654((String)tradesData.profession()));
                if (prof == null) {
                    VillagerAPI.LOGGER.warn("Profession {} not found for trades {}", (Object)tradesData.profession(), name);
                    return;
                }
                class_3853.field_17067.put(prof, tradesData.trades());
                VillagerAPI.LOGGER.info("Registered trades from pack: {}", name);
            }
            catch (Exception e) {
                VillagerAPI.LOGGER.error("Failed to register trades: {}", name, (Object)e);
            }
        });
        VillagerPackCodecs.setRegistryLookup(null);
    }

    public static void registerGifts(Map<String, JsonObject> data) {
        if (data.isEmpty()) {
            return;
        }
        VillagerAPI.LOGGER.info("Staging {} gifts from packs", (Object)data.size());
        data.forEach((name, json) -> VAPIGifts.registerFromPack(name, json));
    }

    public static void registerBiomeTrades(Map<String, JsonObject> data) {
        VillagerPackRegistry.registerBiomeTrades(data, null);
    }

    public static void registerBiomeTrades(Map<String, JsonObject> data, class_7225.class_7874 registryLookup) {
        if (data.isEmpty()) {
            return;
        }
        VillagerAPI.LOGGER.info("Registering biome-specific trades for {} professions from packs", (Object)data.size());
        VillagerPackCodecs.setRegistryLookup(registryLookup);
        data.forEach((name, json) -> {
            try {
                class_3852 prof;
                VillagerPackCodecs.BiomeTradesData biomeTradesData = VillagerPackCodecs.parseBiomeTrades(json);
                Supplier<class_3852> profession = VAPIProfessions.getDynamicProfession(biomeTradesData.profession());
                class_3852 class_38522 = prof = profession != null ? profession.get() : (class_3852)class_7923.field_41195.method_10223(class_2960.method_60654((String)biomeTradesData.profession()));
                if (prof == null) {
                    VillagerAPI.LOGGER.warn("Profession {} not found for biome trades {}", (Object)biomeTradesData.profession(), name);
                    return;
                }
                biomeTradesData.biomeTradeMap().forEach((villagerType, biomeTrades) -> {
                    BiomeTradesCache.registerBiomeTrades(prof, villagerType, (Int2ObjectMap<class_3853.class_1652[]>)biomeTrades);
                    VillagerAPI.LOGGER.info("Registered biome trades from pack for {} in biome type {}", (Object)biomeTradesData.profession(), (Object)class_7923.field_41194.method_10221(villagerType));
                });
                biomeTradesData.replaceFlags().forEach((villagerType, levelFlags) -> levelFlags.forEach((level, replace) -> {
                    BiomeTradesCache.registerReplaceFlag(prof, villagerType, level, replace);
                    VillagerAPI.LOGGER.debug("Set replace flag for {} biome {} level {} to {}", new Object[]{biomeTradesData.profession(), class_7923.field_41194.method_10221(villagerType), level, replace});
                }));
                Int2ObjectMap baseTrades = (Int2ObjectMap)class_3853.field_17067.get(prof);
                if (baseTrades == null) {
                    VillagerAPI.LOGGER.warn("No base trades for profession {}, cannot apply biome trades", (Object)biomeTradesData.profession());
                    return;
                }
                biomeTradesData.biomeTradeMap().forEach((villagerType, biomeTrades) -> {
                    Int2ObjectOpenHashMap mergedTrades = new Int2ObjectOpenHashMap();
                    baseTrades.int2ObjectEntrySet().forEach(arg_0 -> VillagerPackRegistry.lambda$registerBiomeTrades$8((Int2ObjectMap)mergedTrades, arg_0));
                    biomeTrades.int2ObjectEntrySet().forEach(arg_0 -> VillagerPackRegistry.lambda$registerBiomeTrades$9((Int2ObjectMap)mergedTrades, arg_0));
                    VillagerAPI.LOGGER.info("Applied biome trades from pack for {} in biome type {}", (Object)biomeTradesData.profession(), (Object)class_7923.field_41194.method_10221(villagerType));
                });
            }
            catch (Exception e) {
                VillagerAPI.LOGGER.error("Failed to register biome trades: {}", name, (Object)e);
            }
        });
        VillagerPackCodecs.setRegistryLookup(null);
    }

    private static /* synthetic */ void lambda$registerBiomeTrades$9(Int2ObjectMap mergedTrades, Int2ObjectMap.Entry entry) {
        int level = entry.getIntKey();
        class_3853.class_1652[] biomeListings = (class_3853.class_1652[])entry.getValue();
        if (mergedTrades.containsKey(level)) {
            class_3853.class_1652[] baseListings = (class_3853.class_1652[])mergedTrades.get(level);
            class_3853.class_1652[] combined = new class_3853.class_1652[baseListings.length + biomeListings.length];
            System.arraycopy(baseListings, 0, combined, 0, baseListings.length);
            System.arraycopy(biomeListings, 0, combined, baseListings.length, biomeListings.length);
            mergedTrades.put(level, (Object)combined);
        } else {
            mergedTrades.put(level, (Object)biomeListings);
        }
    }

    private static /* synthetic */ void lambda$registerBiomeTrades$8(Int2ObjectMap mergedTrades, Int2ObjectMap.Entry entry) {
        mergedTrades.put(entry.getIntKey(), (Object)((class_3853.class_1652[])((class_3853.class_1652[])entry.getValue()).clone()));
    }
}

