/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi;

import com.frikinjay.villagerapi.platform.CommonPlatformHelper;
import com.frikinjay.villagerapi.registry.VAPICreativeTabs;
import com.frikinjay.villagerapi.registry.VAPIGifts;
import com.frikinjay.villagerapi.registry.VAPIMapDecorations;
import com.frikinjay.villagerapi.registry.VAPIPoiTypes;
import com.frikinjay.villagerapi.registry.VAPIProfessions;
import com.frikinjay.villagerapi.registry.VAPITypes;
import com.frikinjay.villagerapi.registry.VAPIWorkstations;
import com.frikinjay.villagerapi.villagerpack.VillagerPackBiomeMapper;
import com.frikinjay.villagerapi.villagerpack.VillagerPackLoader;
import com.frikinjay.villagerapi.villagerpack.VillagerPackRegistry;
import com.frikinjay.villagerapi.villagerpack.VillagerPackValidator;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VillagerAPI {
    public static final String MOD_ID = "villagerapi";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"villagerapi");
    public static Map<VillagerPackLoader.DataType, Map<String, JsonObject>> packData;
    private static VillagerPackLoader packLoader;

    public static void init() {
        Path villagerPacksDir = CommonPlatformHelper.getGameDirectory().resolve("villagerpacks");
        VillagerPackValidator.validateAllPacks(villagerPacksDir);
        packLoader = new VillagerPackLoader(CommonPlatformHelper.getGameDirectory());
        VillagerPackRegistry.registerCreativeTabsFromPacks(packLoader);
        packData = packLoader.loadAllPacks();
        VAPIWorkstations.init();
        VAPIPoiTypes.init();
        VAPITypes.init();
        VAPIMapDecorations.init();
        VAPIProfessions.init();
        VAPIGifts.init();
        VAPICreativeTabs.init();
    }

    public static void registerBiomeMappingsFromPacks(MinecraftServer server) {
        if (packData != null && packData.containsKey((Object)VillagerPackLoader.DataType.BIOME_MAPPINGS)) {
            VillagerPackBiomeMapper.registerBiomeMappings(packData.get((Object)VillagerPackLoader.DataType.BIOME_MAPPINGS), server);
        }
    }

    public static VillagerPackLoader getPackLoader() {
        return packLoader;
    }

    public static ResourceLocation getRL(String modid, String location) {
        return new ResourceLocation(modid, location);
    }
}

