/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.neoforge.villagerpack;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.platform.CommonPlatformHelper;
import com.frikinjay.villagerapi.villagerpack.VillagerPackHelper;
import com.frikinjay.villagerapi.villagerpack.VillagerPackLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddPackFindersEvent;

@EventBusSubscriber(modid="villagerapi", bus=EventBusSubscriber.Bus.MOD)
public class VillagerPackRegistrationNeoForge {
    @SubscribeEvent
    public static void onAddPackFinders(AddPackFindersEvent event) {
        Path gameDir = CommonPlatformHelper.getGameDirectory();
        Path villagerPacksDir = gameDir.resolve("villagerpacks");
        if (!Files.exists(villagerPacksDir, new LinkOption[0])) {
            VillagerAPI.LOGGER.debug("No villagerpacks directory found at: {}", (Object)villagerPacksDir);
            return;
        }
        try (Stream<Path> packs = Files.list(villagerPacksDir);){
            packs.filter(path -> Files.isDirectory(path, new LinkOption[0]) || Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".zip")).forEach(packPath -> {
                try (VillagerPackLoader.VillagerPack pack = new VillagerPackLoader.VillagerPack((Path)packPath);){
                    boolean hasRelevantContent;
                    if (!pack.hasConfig()) {
                        VillagerAPI.LOGGER.debug("Skipping '{}' - no villagerapi_config.json (not a villagerpack)", (Object)packPath.getFileName());
                        return;
                    }
                    boolean bl = hasRelevantContent = event.getPackType() == PackType.SERVER_DATA && pack.hasData() || event.getPackType() == PackType.CLIENT_RESOURCES && pack.hasAssets();
                    if (!hasRelevantContent) {
                        VillagerAPI.LOGGER.debug("Skipping '{}' for {} - no relevant content", (Object)pack.getDisplayName(), (Object)event.getPackType().name());
                        return;
                    }
                    String displayName = pack.getDisplayName();
                    String namespace = pack.getNamespace();
                    event.addRepositorySource(consumer -> {
                        Pack registeredPack = VillagerPackRegistrationNeoForge.createPack(packPath, displayName, event.getPackType());
                        if (registeredPack != null) {
                            consumer.accept(registeredPack);
                            VillagerAPI.LOGGER.info("Registered villagerpack '{}' as {} (namespace: {})", new Object[]{displayName, event.getPackType().name(), namespace});
                        } else {
                            VillagerAPI.LOGGER.warn("Failed to create pack for villagerpack: {}", (Object)displayName);
                        }
                    });
                }
                catch (Exception e) {
                    VillagerAPI.LOGGER.error("Failed to register villagerpack: {}", (Object)packPath.getFileName(), (Object)e);
                }
            });
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to load villagerpacks", (Throwable)e);
        }
    }

    private static Pack createPack(Path packPath, String packName, PackType packType) {
        return VillagerPackHelper.createPack(packPath, packName, packType);
    }
}

