/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.platform.neoforge;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.registries.DeferredRegister;

public class CommonPlatformHelperImpl {
    private static final Map<String, DeferredRegister<Block>> WORKSTATION_BLOCK_REGISTERS = new HashMap<String, DeferredRegister<Block>>();
    private static final Map<String, DeferredRegister<Item>> WORKSTATION_ITEM_REGISTERS = new HashMap<String, DeferredRegister<Item>>();
    private static final Map<String, DeferredRegister<VillagerType>> VILLAGER_TYPE_REGISTERS = new HashMap<String, DeferredRegister<VillagerType>>();
    private static final Map<String, DeferredRegister<MapDecorationType>> MAP_DECO_TYPE_REGISTERS = new HashMap<String, DeferredRegister<MapDecorationType>>();
    private static final Map<String, DeferredRegister<VillagerProfession>> PROFESSION_REGISTERS = new HashMap<String, DeferredRegister<VillagerProfession>>();
    private static final Map<String, DeferredRegister<PoiType>> POI_TYPE_REGISTERS = new HashMap<String, DeferredRegister<PoiType>>();
    public static final DeferredRegister<Block> WORKSTATION_BLOCKS = CommonPlatformHelperImpl.getOrCreateWorkstationBlockRegister("villagerapi");
    public static final DeferredRegister<Item> WORKSTATION_ITEMS = CommonPlatformHelperImpl.getOrCreateWorkstationItemRegister("villagerapi");
    public static final DeferredRegister<VillagerType> VILLAGER_TYPES = CommonPlatformHelperImpl.getOrCreateVillagerTypeRegister("villagerapi");
    public static final DeferredRegister<MapDecorationType> MAP_DECORATION_TYPES = CommonPlatformHelperImpl.getOrCreateMapDecoTypeRegister("villagerapi");
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = CommonPlatformHelperImpl.getOrCreateProfessionRegister("villagerapi");
    public static final DeferredRegister<PoiType> POI_TYPES = CommonPlatformHelperImpl.getOrCreatePoiTypeRegister("villagerapi");

    private static DeferredRegister<Block> getOrCreateWorkstationBlockRegister(String namespace) {
        return WORKSTATION_BLOCK_REGISTERS.computeIfAbsent(namespace, ns -> DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)ns));
    }

    private static DeferredRegister<Item> getOrCreateWorkstationItemRegister(String namespace) {
        return WORKSTATION_ITEM_REGISTERS.computeIfAbsent(namespace, ns -> DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)ns));
    }

    private static DeferredRegister<VillagerType> getOrCreateVillagerTypeRegister(String namespace) {
        return VILLAGER_TYPE_REGISTERS.computeIfAbsent(namespace, ns -> DeferredRegister.create((Registry)BuiltInRegistries.VILLAGER_TYPE, (String)ns));
    }

    private static DeferredRegister<MapDecorationType> getOrCreateMapDecoTypeRegister(String namespace) {
        return MAP_DECO_TYPE_REGISTERS.computeIfAbsent(namespace, ns -> DeferredRegister.create((Registry)BuiltInRegistries.MAP_DECORATION_TYPE, (String)ns));
    }

    private static DeferredRegister<VillagerProfession> getOrCreateProfessionRegister(String namespace) {
        return PROFESSION_REGISTERS.computeIfAbsent(namespace, ns -> DeferredRegister.create((Registry)BuiltInRegistries.VILLAGER_PROFESSION, (String)ns));
    }

    private static DeferredRegister<PoiType> getOrCreatePoiTypeRegister(String namespace) {
        return POI_TYPE_REGISTERS.computeIfAbsent(namespace, ns -> DeferredRegister.create((Registry)BuiltInRegistries.POINT_OF_INTEREST_TYPE, (String)ns));
    }

    public static Supplier<Block> registerWorkstationBlock(String namespace, String name, Supplier<Block> block) {
        DeferredRegister<Block> register = CommonPlatformHelperImpl.getOrCreateWorkstationBlockRegister(namespace);
        return register.register(name, block);
    }

    public static Supplier<Item> registerWorkstationItem(String namespace, String name, Supplier<Item> item) {
        DeferredRegister<Item> register = CommonPlatformHelperImpl.getOrCreateWorkstationItemRegister(namespace);
        return register.register(name, item);
    }

    public static Supplier<VillagerType> registerVillagerType(String namespace, String name, Supplier<VillagerType> type) {
        DeferredRegister<VillagerType> register = CommonPlatformHelperImpl.getOrCreateVillagerTypeRegister(namespace);
        return register.register(name, type);
    }

    public static Supplier<MapDecorationType> registerMapDecorationType(String namespace, String name, Supplier<MapDecorationType> type) {
        DeferredRegister<MapDecorationType> register = CommonPlatformHelperImpl.getOrCreateMapDecoTypeRegister(namespace);
        return register.register(name, type);
    }

    public static Supplier<VillagerProfession> registerProfession(String namespace, String name, Supplier<VillagerProfession> profession) {
        DeferredRegister<VillagerProfession> register = CommonPlatformHelperImpl.getOrCreateProfessionRegister(namespace);
        return register.register(name, profession);
    }

    public static Supplier<PoiType> registerPoiType(String namespace, String name, Supplier<Set<BlockState>> matchingStates) {
        DeferredRegister<PoiType> register = CommonPlatformHelperImpl.getOrCreatePoiTypeRegister(namespace);
        return register.register(name, () -> {
            Set states = (Set)matchingStates.get();
            return new PoiType(states, 1, 1);
        });
    }

    public static boolean isModLoadedMV(String id) {
        return ModList.get().isLoaded(id);
    }

    public static Path getGameDirectory() {
        return FMLPaths.GAMEDIR.get();
    }

    public static void registerAll(IEventBus modEventBus) {
        WORKSTATION_BLOCKS.register(modEventBus);
        WORKSTATION_ITEMS.register(modEventBus);
        VILLAGER_TYPES.register(modEventBus);
        MAP_DECORATION_TYPES.register(modEventBus);
        PROFESSIONS.register(modEventBus);
        POI_TYPES.register(modEventBus);
        WORKSTATION_BLOCK_REGISTERS.values().forEach(reg -> {
            if (reg != WORKSTATION_BLOCKS) {
                reg.register(modEventBus);
            }
        });
        WORKSTATION_ITEM_REGISTERS.values().forEach(reg -> {
            if (reg != WORKSTATION_ITEMS) {
                reg.register(modEventBus);
            }
        });
        VILLAGER_TYPE_REGISTERS.values().forEach(reg -> {
            if (reg != VILLAGER_TYPES) {
                reg.register(modEventBus);
            }
        });
        MAP_DECO_TYPE_REGISTERS.values().forEach(reg -> {
            if (reg != MAP_DECORATION_TYPES) {
                reg.register(modEventBus);
            }
        });
        PROFESSION_REGISTERS.values().forEach(reg -> {
            if (reg != PROFESSIONS) {
                reg.register(modEventBus);
            }
        });
        POI_TYPE_REGISTERS.values().forEach(reg -> {
            if (reg != POI_TYPES) {
                reg.register(modEventBus);
            }
        });
    }
}

