/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.registry;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.villagerpack.VillagerPackConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class VAPICreativeTabs {
    private static final Map<String, TabData> DYNAMIC_TABS = new HashMap<String, TabData>();

    public static void init() {
    }

    public static void registerTab(VillagerPackConfig config) {
        String namespace = config.getNamespace();
        if (DYNAMIC_TABS.containsKey(namespace)) {
            VillagerAPI.LOGGER.warn("Creative tab for namespace '{}' already registered", (Object)namespace);
            return;
        }
        TabData tabData = new TabData(namespace, config.getDisplayName(), config.getCreativeTabIcon());
        DYNAMIC_TABS.put(namespace, tabData);
        VillagerAPI.LOGGER.info("Registered creative tab for villagerpack '{}' (namespace: {})", (Object)config.getDisplayName(), (Object)namespace);
    }

    public static void addWorkstationToTab(String packName, Supplier<Block> workstation) {
        TabData tabData = DYNAMIC_TABS.get(packName);
        if (tabData != null) {
            tabData.addWorkstation(workstation);
        }
    }

    public static TabData getTabData(String namespace) {
        return DYNAMIC_TABS.get(namespace);
    }

    public static Map<String, TabData> getAllTabs() {
        return new HashMap<String, TabData>(DYNAMIC_TABS);
    }

    public static ResourceLocation getTabId(String namespace) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)"villagerpack_tab");
    }

    public static class TabData {
        private final String namespace;
        private final String displayName;
        private final ResourceLocation iconItemId;
        private final List<Supplier<Block>> workstations;

        public TabData(String namespace, String displayName, ResourceLocation iconItemId) {
            this.namespace = namespace;
            this.displayName = displayName;
            this.iconItemId = iconItemId;
            this.workstations = new ArrayList<Supplier<Block>>();
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public ResourceLocation getIconItemId() {
            return this.iconItemId;
        }

        public ItemStack getIconItemStack() {
            Item item = (Item)BuiltInRegistries.ITEM.get(this.iconItemId);
            if (item == null || item == Items.AIR) {
                VillagerAPI.LOGGER.warn("Creative tab icon item '{}' not found, using emerald", (Object)this.iconItemId);
                return new ItemStack((ItemLike)Items.EMERALD);
            }
            return new ItemStack((ItemLike)item);
        }

        public List<Supplier<Block>> getWorkstations() {
            return this.workstations;
        }

        public void addWorkstation(Supplier<Block> workstation) {
            this.workstations.add(workstation);
        }
    }
}

