/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.registry;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.mixin.GiveGiftToHeroAccessor;
import com.frikinjay.villagerapi.registry.VAPIProfessions;
import com.frikinjay.villagerapi.villagerpack.VillagerPackCodecs;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.storage.loot.LootTable;

public class VAPIGifts {
    private static final Map<String, LazyGift> DYNAMIC_GIFTS = new HashMap<String, LazyGift>();

    public static void init() {
    }

    public static void registerFromPack(String name, JsonObject json) {
        try {
            VillagerPackCodecs.GiftData giftData = VillagerPackCodecs.parseGift(json);
            LazyGift lazyGift = new LazyGift(name, giftData.profession(), giftData.lootTable());
            DYNAMIC_GIFTS.put(name, lazyGift);
            VillagerAPI.LOGGER.info("Registered gift from pack: {} (will be applied lazily)", (Object)name);
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to register gift from pack: {}", (Object)name, (Object)e);
        }
    }

    public static void applyAllGifts() {
        Map<VillagerProfession, ResourceKey<LootTable>> gifts = GiveGiftToHeroAccessor.getGifts();
        DYNAMIC_GIFTS.values().forEach(lazyGift -> {
            VillagerProfession profession = lazyGift.resolveProfession();
            if (profession != null) {
                gifts.put(profession, lazyGift.getLootTable());
                VillagerAPI.LOGGER.debug("Applied gift for profession {}", (Object)lazyGift.professionName);
            }
        });
        VillagerAPI.LOGGER.info("Applied {} gifts from packs", (Object)DYNAMIC_GIFTS.size());
    }

    public static Map<String, ResourceKey<LootTable>> getDynamicGifts() {
        HashMap<String, ResourceKey<LootTable>> result = new HashMap<String, ResourceKey<LootTable>>();
        DYNAMIC_GIFTS.forEach((name, lazyGift) -> result.put((String)name, lazyGift.getLootTable()));
        return result;
    }

    private static class LazyGift {
        private final String name;
        private final String professionName;
        private final ResourceKey<LootTable> lootTable;
        private VillagerProfession cachedProfession;

        public LazyGift(String name, String professionName, ResourceLocation lootTableId) {
            this.name = name;
            this.professionName = professionName;
            this.lootTable = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTableId);
        }

        public ResourceKey<LootTable> getLootTable() {
            return this.lootTable;
        }

        public VillagerProfession resolveProfession() {
            if (this.cachedProfession != null) {
                return this.cachedProfession;
            }
            Supplier<VillagerProfession> professionSupplier = VAPIProfessions.getDynamicProfession(this.professionName);
            VillagerProfession villagerProfession = this.cachedProfession = professionSupplier != null ? professionSupplier.get() : (VillagerProfession)BuiltInRegistries.VILLAGER_PROFESSION.get(ResourceLocation.parse((String)this.professionName));
            if (this.cachedProfession == null) {
                VillagerAPI.LOGGER.warn("Profession {} not found for gift {}", (Object)this.professionName, (Object)this.name);
            }
            return this.cachedProfession;
        }
    }
}

