/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.registry;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.platform.CommonPlatformHelper;
import com.frikinjay.villagerapi.villagerpack.VillagerPackCodecs;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.entity.npc.VillagerType;

public class VAPITypes {
    private static final Map<String, Supplier<VillagerType>> DYNAMIC_TYPES = new HashMap<String, Supplier<VillagerType>>();

    public static void init() {
    }

    public static void registerFromPack(String name, JsonObject json) {
        try {
            VillagerPackCodecs.VillagerTypeData typeData = VillagerPackCodecs.parseVillagerType(json);
            String registryName = name.replace("/", "_");
            String namespace = typeData.namespace() != null ? typeData.namespace() : "villagerapi";
            Supplier<VillagerType> type = CommonPlatformHelper.registerVillagerType(namespace, registryName, () -> new VillagerType(typeData.name()));
            DYNAMIC_TYPES.put(name, type);
            VillagerAPI.LOGGER.info("Registered villager type from pack: {}", (Object)name);
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to register villager type from pack: {}", (Object)name, (Object)e);
        }
    }

    public static Supplier<VillagerType> getDynamicType(String name) {
        return DYNAMIC_TYPES.get(name);
    }

    public static Map<String, Supplier<VillagerType>> getDynamicTypes() {
        return new HashMap<String, Supplier<VillagerType>>(DYNAMIC_TYPES);
    }
}

