/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.registry;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.platform.CommonPlatformHelper;
import com.frikinjay.villagerapi.registry.VAPICreativeTabs;
import com.frikinjay.villagerapi.villagerpack.VillagerPackCodecs;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class VAPIWorkstations {
    private static final Map<String, Supplier<Block>> DYNAMIC_WORKSTATIONS = new HashMap<String, Supplier<Block>>();

    public static void init() {
    }

    public static void registerFromPack(String name, JsonObject json) {
        try {
            VillagerPackCodecs.WorkstationData workstationData = VillagerPackCodecs.parseWorkstation(json);
            String registryName = name.replace("/", "_");
            String namespace = workstationData.namespace() != null ? workstationData.namespace() : "villagerapi";
            Supplier<Block> block = CommonPlatformHelper.registerWorkstationBlock(namespace, registryName, () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CARTOGRAPHY_TABLE)));
            CommonPlatformHelper.registerWorkstationItem(namespace, registryName, () -> new BlockItem((Block)block.get(), new Item.Properties()));
            DYNAMIC_WORKSTATIONS.put(name, block);
            if (json.has("_pack_namespace")) {
                String packNamespace = json.get("_pack_namespace").getAsString();
                VAPICreativeTabs.addWorkstationToTab(packNamespace, block);
                VillagerAPI.LOGGER.debug("Added workstation '{}' to creative tab for pack '{}'", (Object)registryName, (Object)packNamespace);
            }
            VillagerAPI.LOGGER.info("Registered villager workstation from pack: {}", (Object)name);
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to register villager workstation from pack: {}", (Object)name, (Object)e);
        }
    }

    public static Supplier<Block> getDynamicWorkstation(String name) {
        return DYNAMIC_WORKSTATIONS.get(name);
    }

    public static Map<String, Supplier<Block>> getDynamicWorkstations() {
        return new HashMap<String, Supplier<Block>>(DYNAMIC_WORKSTATIONS);
    }
}

