/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.villagerpack;

import com.frikinjay.villagerapi.VillagerAPI;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;

public class BiomeTradesCache {
    private static final Map<VillagerProfession, Map<VillagerType, Int2ObjectMap<VillagerTrades.ItemListing[]>>> BIOME_TRADES_CACHE = new HashMap<VillagerProfession, Map<VillagerType, Int2ObjectMap<VillagerTrades.ItemListing[]>>>();
    private static final Map<VillagerProfession, Map<VillagerType, Map<Integer, Boolean>>> REPLACE_FLAGS = new HashMap<VillagerProfession, Map<VillagerType, Map<Integer, Boolean>>>();

    public static void registerBiomeTrades(VillagerProfession profession, VillagerType villagerType, Int2ObjectMap<VillagerTrades.ItemListing[]> trades) {
        BIOME_TRADES_CACHE.computeIfAbsent(profession, k -> new HashMap()).put(villagerType, trades);
        VillagerAPI.LOGGER.debug("Registered biome trades for profession {} in biome type {}", (Object)profession, (Object)villagerType);
    }

    public static Int2ObjectMap<VillagerTrades.ItemListing[]> getBiomeTrades(VillagerProfession profession, VillagerType villagerType) {
        Map<VillagerType, Int2ObjectMap<VillagerTrades.ItemListing[]>> professionTrades = BIOME_TRADES_CACHE.get(profession);
        if (professionTrades == null) {
            return null;
        }
        return professionTrades.get(villagerType);
    }

    public static boolean hasBiomeTrades(VillagerProfession profession) {
        return BIOME_TRADES_CACHE.containsKey(profession);
    }

    public static void registerReplaceFlag(VillagerProfession profession, VillagerType villagerType, int level, boolean replace) {
        REPLACE_FLAGS.computeIfAbsent(profession, k -> new HashMap()).computeIfAbsent(villagerType, k -> new HashMap()).put(level, replace);
    }

    private static boolean shouldReplace(VillagerProfession profession, VillagerType villagerType, int level) {
        Map<VillagerType, Map<Integer, Boolean>> professionFlags = REPLACE_FLAGS.get(profession);
        if (professionFlags == null) {
            return false;
        }
        Map<Integer, Boolean> typeFlags = professionFlags.get(villagerType);
        if (typeFlags == null) {
            return false;
        }
        return typeFlags.getOrDefault(level, false);
    }

    public static Int2ObjectMap<VillagerTrades.ItemListing[]> getMergedTrades(VillagerProfession profession, VillagerType villagerType) {
        Int2ObjectMap baseTrades = (Int2ObjectMap)VillagerTrades.TRADES.get(profession);
        if (baseTrades == null) {
            return null;
        }
        Int2ObjectMap<VillagerTrades.ItemListing[]> biomeTrades = BiomeTradesCache.getBiomeTrades(profession, villagerType);
        if (biomeTrades == null) {
            return baseTrades;
        }
        Int2ObjectOpenHashMap mergedTrades = new Int2ObjectOpenHashMap();
        baseTrades.int2ObjectEntrySet().forEach(arg_0 -> BiomeTradesCache.lambda$getMergedTrades$3((Int2ObjectMap)mergedTrades, arg_0));
        biomeTrades.int2ObjectEntrySet().forEach(arg_0 -> BiomeTradesCache.lambda$getMergedTrades$4(profession, villagerType, (Int2ObjectMap)mergedTrades, arg_0));
        return mergedTrades;
    }

    public static void clear() {
        BIOME_TRADES_CACHE.clear();
        REPLACE_FLAGS.clear();
        VillagerAPI.LOGGER.debug("Cleared biome trades cache");
    }

    private static /* synthetic */ void lambda$getMergedTrades$4(VillagerProfession profession, VillagerType villagerType, Int2ObjectMap mergedTrades, Int2ObjectMap.Entry entry) {
        int level = entry.getIntKey();
        VillagerTrades.ItemListing[] biomeListings = (VillagerTrades.ItemListing[])entry.getValue();
        if (BiomeTradesCache.shouldReplace(profession, villagerType, level)) {
            mergedTrades.put(level, (Object)biomeListings);
            VillagerAPI.LOGGER.debug("Replaced trades for profession {} biome {} level {} (replace mode)", new Object[]{profession, villagerType, level});
        } else if (mergedTrades.containsKey(level)) {
            VillagerTrades.ItemListing[] baseListings = (VillagerTrades.ItemListing[])mergedTrades.get(level);
            VillagerTrades.ItemListing[] combined = new VillagerTrades.ItemListing[baseListings.length + biomeListings.length];
            System.arraycopy(baseListings, 0, combined, 0, baseListings.length);
            System.arraycopy(biomeListings, 0, combined, baseListings.length, biomeListings.length);
            mergedTrades.put(level, (Object)combined);
            VillagerAPI.LOGGER.debug("Merged trades for profession {} biome {} level {} (add mode)", new Object[]{profession, villagerType, level});
        } else {
            mergedTrades.put(level, (Object)biomeListings);
        }
    }

    private static /* synthetic */ void lambda$getMergedTrades$3(Int2ObjectMap mergedTrades, Int2ObjectMap.Entry entry) {
        mergedTrades.put(entry.getIntKey(), (Object)((VillagerTrades.ItemListing[])((VillagerTrades.ItemListing[])entry.getValue()).clone()));
    }
}

