/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.villagerpack;

import com.frikinjay.villagerapi.VillagerAPI;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;

public class VillagerPackConfig {
    private final String namespace;
    private final String displayName;
    private final String description;
    private final String version;
    private final String author;
    private final ResourceLocation creativeTabIcon;

    private VillagerPackConfig(String namespace, String displayName, String description, String version, String author, ResourceLocation creativeTabIcon) {
        this.namespace = namespace;
        this.displayName = displayName;
        this.description = description;
        this.version = version;
        this.author = author;
        this.creativeTabIcon = creativeTabIcon;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAuthor() {
        return this.author;
    }

    public ResourceLocation getCreativeTabIcon() {
        return this.creativeTabIcon;
    }

    public static VillagerPackConfig load(Path rootPath, String packName) {
        Path configFile = rootPath.resolve("villagerapi_config.json");
        if (Files.exists(configFile, new LinkOption[0])) {
            VillagerPackConfig villagerPackConfig;
            InputStreamReader reader = new InputStreamReader(Files.newInputStream(configFile, new OpenOption[0]));
            try {
                JsonObject config = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                String namespace = config.has("namespace") ? config.get("namespace").getAsString() : VillagerPackConfig.sanitizeNamespace(packName);
                String displayName = config.has("display_name") ? config.get("display_name").getAsString() : packName;
                String description = config.has("description") ? config.get("description").getAsString() : "";
                String version = config.has("version") ? config.get("version").getAsString() : "1.0.0";
                String author = config.has("author") ? config.get("author").getAsString() : "Unknown";
                ResourceLocation creativeTabIcon = config.has("creative_tab_icon") ? ResourceLocation.parse((String)config.get("creative_tab_icon").getAsString()) : ResourceLocation.withDefaultNamespace((String)"emerald");
                VillagerAPI.LOGGER.info("Loaded config for villagerpack '{}' (namespace: {})", (Object)displayName, (Object)namespace);
                villagerPackConfig = new VillagerPackConfig(namespace, displayName, description, version, author, creativeTabIcon);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    VillagerAPI.LOGGER.error("Failed to load villagerapi_config.json for pack '{}', using defaults", (Object)packName, (Object)e);
                }
            }
            reader.close();
            return villagerPackConfig;
        } else {
            VillagerAPI.LOGGER.debug("No villagerapi_config.json found for pack '{}', using defaults", (Object)packName);
        }
        String defaultNamespace = VillagerPackConfig.sanitizeNamespace(packName);
        return new VillagerPackConfig(defaultNamespace, packName, "", "1.0.0", "Unknown", ResourceLocation.withDefaultNamespace((String)"emerald"));
    }

    private static String sanitizeNamespace(String packName) {
        String cleaned = packName.replaceAll("-\\d+\\.\\d+.*$", "").replaceAll("_v?\\d+\\.\\d+.*$", "").replaceAll("-mc\\d+\\.\\d+.*$", "").replaceAll("\\+.*$", "").replaceAll("-fabric$", "").replaceAll("-forge$", "").replaceAll("-neoforge$", "");
        return cleaned.toLowerCase().replace(" ", "_").replaceAll("[^a-z0-9_.-]", "_").replaceAll("^_+|_+$", "").replaceAll("_+", "_");
    }

    public String toString() {
        return "VillagerPackConfig{namespace='" + this.namespace + "', displayName='" + this.displayName + "', description='" + this.description + "', version='" + this.version + "', author='" + this.author + "', creativeTabIcon=" + String.valueOf(this.creativeTabIcon) + "}";
    }
}

