/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.villagerpack;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.registry.VAPICreativeTabs;
import com.frikinjay.villagerapi.registry.VAPIGifts;
import com.frikinjay.villagerapi.registry.VAPIMapDecorations;
import com.frikinjay.villagerapi.registry.VAPIPoiTypes;
import com.frikinjay.villagerapi.registry.VAPIProfessions;
import com.frikinjay.villagerapi.registry.VAPIStructureTags;
import com.frikinjay.villagerapi.registry.VAPITypes;
import com.frikinjay.villagerapi.registry.VAPIWorkstations;
import com.frikinjay.villagerapi.villagerpack.BiomeTradesCache;
import com.frikinjay.villagerapi.villagerpack.VillagerPackCodecs;
import com.frikinjay.villagerapi.villagerpack.VillagerPackConfig;
import com.frikinjay.villagerapi.villagerpack.VillagerPackLoader;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;

public class VillagerPackRegistry {
    public static void registerCreativeTabsFromPacks(VillagerPackLoader loader) {
        if (loader == null) {
            return;
        }
        try {
            for (VillagerPackLoader.VillagerPack pack : loader.getDiscoveredPacks()) {
                if (pack.hasConfig()) {
                    VillagerPackConfig config = pack.getConfig();
                    VAPICreativeTabs.registerTab(config);
                }
                pack.close();
            }
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to register creative tabs from packs", (Throwable)e);
        }
    }

    public static void registerWorkstations(Map<String, JsonObject> data) {
        if (data.isEmpty()) {
            return;
        }
        VillagerAPI.LOGGER.info("Registering {} villager workstations from packs", (Object)data.size());
        data.forEach((name, json) -> VAPIWorkstations.registerFromPack(name, json));
    }

    public static void registerVillagerTypes(Map<String, JsonObject> data) {
        if (data.isEmpty()) {
            return;
        }
        VillagerAPI.LOGGER.info("Registering {} villager types from packs", (Object)data.size());
        data.forEach((name, json) -> VAPITypes.registerFromPack(name, json));
    }

    public static void registerMapDecorationTypes(Map<String, JsonObject> data) {
        if (data.isEmpty()) {
            return;
        }
        VillagerAPI.LOGGER.info("Registering {} map decoration types from packs", (Object)data.size());
        data.forEach((name, json) -> VAPIMapDecorations.registerFromPack(name, json));
    }

    public static void registerStructureTags(Map<String, JsonObject> data) {
        if (data.isEmpty()) {
            return;
        }
        VillagerAPI.LOGGER.info("Creating {} structure tags from packs", (Object)data.size());
        data.forEach((name, json) -> VAPIStructureTags.registerFromPack(name, json));
    }

    public static void registerPoiTypes(Map<String, JsonObject> data) {
        if (data.isEmpty()) {
            return;
        }
        VillagerAPI.LOGGER.info("Registering {} POI types from packs", (Object)data.size());
        data.forEach((name, json) -> VAPIPoiTypes.registerFromPack(name, json));
    }

    public static void registerProfessions(Map<String, JsonObject> data) {
        if (data.isEmpty()) {
            return;
        }
        VillagerAPI.LOGGER.info("Registering {} professions from packs", (Object)data.size());
        data.forEach((name, json) -> VAPIProfessions.registerFromPack(name, json));
    }

    public static void validateRegistrations() {
        VillagerAPI.LOGGER.info("Validating POI types and professions...");
        VAPIPoiTypes.validatePoiTypes();
        VAPIProfessions.validateProfessions();
    }

    public static void registerTrades(Map<String, JsonObject> data) {
        VillagerPackRegistry.registerTrades(data, null);
    }

    public static void registerTrades(Map<String, JsonObject> data, HolderLookup.Provider registryLookup) {
        if (data.isEmpty()) {
            return;
        }
        VillagerAPI.LOGGER.info("Registering trades for {} professions from packs", (Object)data.size());
        VillagerPackCodecs.setRegistryLookup(registryLookup);
        data.forEach((name, json) -> {
            try {
                VillagerProfession prof;
                VillagerPackCodecs.TradesData tradesData = VillagerPackCodecs.parseTrades(json);
                Supplier<VillagerProfession> professionSupplier = VAPIProfessions.getDynamicProfession(tradesData.profession());
                VillagerProfession villagerProfession = prof = professionSupplier != null ? professionSupplier.get() : (VillagerProfession)BuiltInRegistries.VILLAGER_PROFESSION.get(ResourceLocation.parse((String)tradesData.profession()));
                if (prof == null) {
                    VillagerAPI.LOGGER.warn("Profession {} not found for trades {}", (Object)tradesData.profession(), name);
                    return;
                }
                VillagerTrades.TRADES.put(prof, tradesData.trades());
                VillagerAPI.LOGGER.info("Registered trades from pack: {}", name);
            }
            catch (Exception e) {
                VillagerAPI.LOGGER.error("Failed to register trades: {}", name, (Object)e);
            }
        });
        VillagerPackCodecs.setRegistryLookup(null);
    }

    public static void registerGifts(Map<String, JsonObject> data) {
        if (data.isEmpty()) {
            return;
        }
        VillagerAPI.LOGGER.info("Staging {} gifts from packs", (Object)data.size());
        data.forEach((name, json) -> VAPIGifts.registerFromPack(name, json));
    }

    public static void registerBiomeTrades(Map<String, JsonObject> data) {
        VillagerPackRegistry.registerBiomeTrades(data, null);
    }

    public static void registerBiomeTrades(Map<String, JsonObject> data, HolderLookup.Provider registryLookup) {
        if (data.isEmpty()) {
            return;
        }
        VillagerAPI.LOGGER.info("Registering biome-specific trades for {} professions from packs", (Object)data.size());
        VillagerPackCodecs.setRegistryLookup(registryLookup);
        data.forEach((name, json) -> {
            try {
                VillagerProfession prof;
                VillagerPackCodecs.BiomeTradesData biomeTradesData = VillagerPackCodecs.parseBiomeTrades(json);
                Supplier<VillagerProfession> profession = VAPIProfessions.getDynamicProfession(biomeTradesData.profession());
                VillagerProfession villagerProfession = prof = profession != null ? profession.get() : (VillagerProfession)BuiltInRegistries.VILLAGER_PROFESSION.get(ResourceLocation.parse((String)biomeTradesData.profession()));
                if (prof == null) {
                    VillagerAPI.LOGGER.warn("Profession {} not found for biome trades {}", (Object)biomeTradesData.profession(), name);
                    return;
                }
                biomeTradesData.biomeTradeMap().forEach((villagerType, biomeTrades) -> {
                    BiomeTradesCache.registerBiomeTrades(prof, villagerType, (Int2ObjectMap<VillagerTrades.ItemListing[]>)biomeTrades);
                    VillagerAPI.LOGGER.info("Registered biome trades from pack for {} in biome type {}", (Object)biomeTradesData.profession(), (Object)BuiltInRegistries.VILLAGER_TYPE.getKey(villagerType));
                });
                biomeTradesData.replaceFlags().forEach((villagerType, levelFlags) -> levelFlags.forEach((level, replace) -> {
                    BiomeTradesCache.registerReplaceFlag(prof, villagerType, level, replace);
                    VillagerAPI.LOGGER.debug("Set replace flag for {} biome {} level {} to {}", new Object[]{biomeTradesData.profession(), BuiltInRegistries.VILLAGER_TYPE.getKey(villagerType), level, replace});
                }));
                Int2ObjectMap baseTrades = (Int2ObjectMap)VillagerTrades.TRADES.get(prof);
                if (baseTrades == null) {
                    VillagerAPI.LOGGER.warn("No base trades for profession {}, cannot apply biome trades", (Object)biomeTradesData.profession());
                    return;
                }
                biomeTradesData.biomeTradeMap().forEach((villagerType, biomeTrades) -> {
                    Int2ObjectOpenHashMap mergedTrades = new Int2ObjectOpenHashMap();
                    baseTrades.int2ObjectEntrySet().forEach(arg_0 -> VillagerPackRegistry.lambda$registerBiomeTrades$11((Int2ObjectMap)mergedTrades, arg_0));
                    biomeTrades.int2ObjectEntrySet().forEach(arg_0 -> VillagerPackRegistry.lambda$registerBiomeTrades$12((Int2ObjectMap)mergedTrades, arg_0));
                    VillagerAPI.LOGGER.info("Applied biome trades from pack for {} in biome type {}", (Object)biomeTradesData.profession(), (Object)BuiltInRegistries.VILLAGER_TYPE.getKey(villagerType));
                });
            }
            catch (Exception e) {
                VillagerAPI.LOGGER.error("Failed to register biome trades: {}", name, (Object)e);
            }
        });
        VillagerPackCodecs.setRegistryLookup(null);
    }

    private static /* synthetic */ void lambda$registerBiomeTrades$12(Int2ObjectMap mergedTrades, Int2ObjectMap.Entry entry) {
        int level = entry.getIntKey();
        VillagerTrades.ItemListing[] biomeListings = (VillagerTrades.ItemListing[])entry.getValue();
        if (mergedTrades.containsKey(level)) {
            VillagerTrades.ItemListing[] baseListings = (VillagerTrades.ItemListing[])mergedTrades.get(level);
            VillagerTrades.ItemListing[] combined = new VillagerTrades.ItemListing[baseListings.length + biomeListings.length];
            System.arraycopy(baseListings, 0, combined, 0, baseListings.length);
            System.arraycopy(biomeListings, 0, combined, baseListings.length, biomeListings.length);
            mergedTrades.put(level, (Object)combined);
        } else {
            mergedTrades.put(level, (Object)biomeListings);
        }
    }

    private static /* synthetic */ void lambda$registerBiomeTrades$11(Int2ObjectMap mergedTrades, Int2ObjectMap.Entry entry) {
        mergedTrades.put(entry.getIntKey(), (Object)((VillagerTrades.ItemListing[])((VillagerTrades.ItemListing[])entry.getValue()).clone()));
    }
}

