/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.block.entity;

import com.agustinbenitez.indexer.block.entity.IndexerControllerBlockEntity;
import com.agustinbenitez.indexer.init.ModBlockEntities;
import com.agustinbenitez.indexer.menu.DropBoxMenu;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DropBoxBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private static final int CONTAINER_SIZE = 54;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)54, (Object)ItemStack.f_41583_);
    private static final int[] SLOTS = new int[54];
    private boolean hadItemsLastTick = false;

    public DropBoxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.DROP_BOX.get(), pos, state);
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.indexer.drop_box");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new DropBoxMenu(id, inventory, this);
    }

    public int m_6643_() {
        return 54;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.hadItemsLastTick = this.hasItems();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    public void m_6836_(int slot, ItemStack stack) {
        ItemStack oldStack = (ItemStack)this.items.get(slot);
        this.items.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && oldStack.m_41619_() && !stack.m_41619_() || !oldStack.m_41619_() && stack.m_41619_()) {
            this.notifyNearbyControllers(this.f_58857_, this.f_58858_);
        }
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.m_5776_()) {
            return;
        }
        boolean hasItemsNow = this.hasItems();
        if (this.hadItemsLastTick && !hasItemsNow) {
            this.notifyNearbyControllers(level, pos);
        } else if (!this.hadItemsLastTick && hasItemsNow) {
            this.notifyNearbyControllers(level, pos);
        }
        this.hadItemsLastTick = hasItemsNow;
    }

    private void notifyNearbyControllers(Level level, BlockPos pos) {
        BlockEntity blockEntity;
        if (level == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = pos.m_121945_(direction);
            blockEntity = level.m_7702_(adjacentPos);
            if (!(blockEntity instanceof IndexerControllerBlockEntity)) continue;
            IndexerControllerBlockEntity controller = (IndexerControllerBlockEntity)blockEntity;
            controller.markNetworkChanged();
            if (controller.isEnabled()) {
                level.m_186460_(adjacentPos, level.m_8055_(adjacentPos).m_60734_(), 1);
            }
            return;
        }
        int searchRadius = 16;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int y = -searchRadius; y <= searchRadius; ++y) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    BlockPos checkPos;
                    if (x == 0 && y == 0 && z == 0 || !((blockEntity = level.m_7702_(checkPos = pos.m_7918_(x, y, z))) instanceof IndexerControllerBlockEntity)) continue;
                    IndexerControllerBlockEntity controller = (IndexerControllerBlockEntity)blockEntity;
                    controller.markNetworkChanged();
                    return;
                }
            }
        }
    }

    public int[] m_7071_(Direction side) {
        return SLOTS;
    }

    public boolean m_7155_(int index, ItemStack itemStack, @Nullable Direction direction) {
        return true;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public NonNullList<ItemStack> getAllItems() {
        return this.items;
    }

    public boolean hasItems() {
        for (ItemStack item : this.items) {
            if (item.m_41619_()) continue;
            return true;
        }
        return false;
    }

    public ItemStack getFirstNonEmptyItem() {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack item = (ItemStack)this.items.get(i);
            if (item.m_41619_()) continue;
            return item;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack result = ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
        if (!result.m_41619_()) {
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                this.notifyNearbyControllers(this.f_58857_, this.f_58858_);
            }
        }
        return result;
    }

    public void dropContents() {
        if (this.f_58857_ == null) {
            return;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.items.get(i);
            if (itemStack.m_41619_()) continue;
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)itemStack);
        }
    }

    @Nullable
    public IndexerControllerBlockEntity findConnectedController() {
        BlockEntity blockEntity;
        if (this.f_58857_ == null) {
            return null;
        }
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = this.f_58858_.m_121945_(direction);
            blockEntity = this.f_58857_.m_7702_(adjacentPos);
            if (!(blockEntity instanceof IndexerControllerBlockEntity)) continue;
            IndexerControllerBlockEntity controller = (IndexerControllerBlockEntity)blockEntity;
            return controller;
        }
        int searchRadius = 16;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int y = -searchRadius; y <= searchRadius; ++y) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    BlockPos checkPos;
                    if (x == 0 && y == 0 && z == 0 || !((blockEntity = this.f_58857_.m_7702_(checkPos = this.f_58858_.m_7918_(x, y, z))) instanceof IndexerControllerBlockEntity)) continue;
                    IndexerControllerBlockEntity controller = (IndexerControllerBlockEntity)blockEntity;
                    return controller;
                }
            }
        }
        return null;
    }

    static {
        for (int i = 0; i < 54; ++i) {
            DropBoxBlockEntity.SLOTS[i] = i;
        }
    }
}

