/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.inventory;

import com.agustinbenitez.indexer.block.entity.IndexerConnectorBlockEntity;
import com.agustinbenitez.indexer.init.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class IndexerConnectorMenu
extends AbstractContainerMenu {
    private final Container container;
    private final IndexerConnectorBlockEntity blockEntity;
    private final ContainerLevelAccess access;
    private static final int BASE_FILTER_SLOTS = 9;
    private static final int FILTER_START_X = 44;
    private static final int FILTER_START_Y = 18;
    private static final int INVENTORY_START_X = 8;
    private static final int INVENTORY_START_Y = 84;
    private static final int HOTBAR_START_Y = 142;
    private static final int SLOT_SIZE = 18;

    public IndexerConnectorMenu(int id, Inventory playerInventory, Container container, IndexerConnectorBlockEntity blockEntity) {
        super((MenuType)ModMenuTypes.INDEXER_CONNECTOR_MENU.get(), id);
        int slotIndex;
        int col;
        int row;
        this.container = container;
        this.blockEntity = blockEntity;
        this.access = blockEntity != null ? ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_()) : ContainerLevelAccess.f_39287_;
        int filterSlots = this.blockEntity != null ? this.blockEntity.getCurrentFilterSlots() : 9;
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                slotIndex = col + row * 3;
                this.m_38897_(new Slot(container, slotIndex, 44 + col * 18, 18 + row * 18){

                    public boolean m_5857_(ItemStack stack) {
                        return true;
                    }

                    public int m_6641_() {
                        return 1;
                    }
                });
            }
        }
        if (filterSlots == 18) {
            for (row = 0; row < 3; ++row) {
                for (col = 0; col < 3; ++col) {
                    slotIndex = 9 + col + row * 3;
                    this.m_38897_(new Slot(container, slotIndex, 44 + (col + 3) * 18, 18 + row * 18){

                        public boolean m_5857_(ItemStack stack) {
                            return true;
                        }

                        public int m_6641_() {
                            return 1;
                        }
                    });
                }
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.m_38897_(new Slot((Container)playerInventory, col2, 8 + col2 * 18, 142));
        }
    }

    public IndexerConnectorMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(9), null);
    }

    public int getFilterSlots() {
        return this.blockEntity != null ? this.blockEntity.getCurrentFilterSlots() : 9;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            int filterSlots;
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            int n = filterSlots = this.blockEntity != null ? this.blockEntity.getCurrentFilterSlots() : 9;
            if (index < filterSlots ? !this.m_38903_(slotStack, filterSlots, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, filterSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        if (this.blockEntity != null) {
            return IndexerConnectorMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
        }
        return this.container.m_6542_(player);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
    }
}

