/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.network;

import com.agustinbenitez.indexer.item.AttributeFilterItem;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class AttributeFilterPacket {
    private final int slotIndex;
    private final String attribute;

    public AttributeFilterPacket(int slotIndex, String attribute) {
        this.slotIndex = slotIndex;
        this.attribute = attribute;
    }

    public AttributeFilterPacket(FriendlyByteBuf buf) {
        this.slotIndex = buf.readInt();
        this.attribute = buf.m_130277_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.slotIndex);
        buf.m_130070_(this.attribute);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ItemStack itemStack;
            ServerPlayer player = context.getSender();
            if (player != null && (itemStack = player.m_150109_().m_8020_(this.slotIndex)).m_41720_() instanceof AttributeFilterItem) {
                CompoundTag tag = itemStack.m_41784_();
                tag.m_128359_("attribute_filter", this.attribute);
                player.m_213846_((Component)Component.m_237110_((String)"message.indexer.attribute_filter.attribute_updated", (Object[])new Object[]{this.attribute}));
            }
        });
        return true;
    }
}

