/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.network;

import com.agustinbenitez.indexer.block.entity.IndexerControllerBlockEntity;
import com.agustinbenitez.indexer.screen.IndexerControllerNetworkScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ContainerListUpdatePacket {
    private final List<ContainerData> containers;

    public ContainerListUpdatePacket(List<IndexerControllerBlockEntity.ContainerNetworkInfo> networkContainers) {
        this.containers = new ArrayList<ContainerData>();
        for (IndexerControllerBlockEntity.ContainerNetworkInfo info : networkContainers) {
            this.containers.add(new ContainerData(info));
        }
    }

    public ContainerListUpdatePacket(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.containers = new ArrayList<ContainerData>();
        for (int i = 0; i < size; ++i) {
            this.containers.add(ContainerData.fromBuffer(buf));
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.containers.size());
        for (ContainerData container : this.containers) {
            container.toBuffer(buf);
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft mc = Minecraft.m_91087_();
            Screen patt1838$temp = mc.f_91080_;
            if (patt1838$temp instanceof IndexerControllerNetworkScreen) {
                IndexerControllerNetworkScreen screen = (IndexerControllerNetworkScreen)patt1838$temp;
                screen.updateContainerListFromServer(this.containers);
            }
        }));
        return true;
    }

    public static class ContainerData {
        public BlockPos position;
        public String containerType;
        public int itemCount;
        public int maxSlots;
        public List<ItemStack> filters;
        public Map<String, Integer> uniqueItems;

        public ContainerData(IndexerControllerBlockEntity.ContainerNetworkInfo info) {
            this.position = info.position;
            this.containerType = info.containerType;
            this.itemCount = info.itemCount;
            this.maxSlots = info.maxSlots;
            this.filters = new ArrayList<ItemStack>(info.filters);
            this.uniqueItems = new HashMap<String, Integer>(info.uniqueItems);
        }

        public ContainerData() {
            this.filters = new ArrayList<ItemStack>();
            this.uniqueItems = new HashMap<String, Integer>();
        }

        public void toBuffer(FriendlyByteBuf buf) {
            buf.m_130064_(this.position);
            buf.m_130070_(this.containerType);
            buf.writeInt(this.itemCount);
            buf.writeInt(this.maxSlots);
            buf.writeInt(this.filters.size());
            for (ItemStack itemStack : this.filters) {
                buf.m_130055_(itemStack);
            }
            buf.writeInt(this.uniqueItems.size());
            for (Map.Entry entry : this.uniqueItems.entrySet()) {
                buf.m_130070_((String)entry.getKey());
                buf.writeInt(((Integer)entry.getValue()).intValue());
            }
        }

        public static ContainerData fromBuffer(FriendlyByteBuf buf) {
            ContainerData data = new ContainerData();
            data.position = buf.m_130135_();
            data.containerType = buf.m_130277_();
            data.itemCount = buf.readInt();
            data.maxSlots = buf.readInt();
            int filterCount = buf.readInt();
            data.filters = new ArrayList<ItemStack>();
            for (int i = 0; i < filterCount; ++i) {
                data.filters.add(buf.m_130267_());
            }
            int uniqueItemsCount = buf.readInt();
            data.uniqueItems = new HashMap<String, Integer>();
            for (int i = 0; i < uniqueItemsCount; ++i) {
                String itemName = buf.m_130277_();
                int quantity = buf.readInt();
                data.uniqueItems.put(itemName, quantity);
            }
            return data;
        }
    }
}

