/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.network;

import com.agustinbenitez.indexer.item.NameFilterItem;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class NameFilterPacket {
    private final int slotIndex;
    private final String customName;

    public NameFilterPacket(int slotIndex, String customName) {
        this.slotIndex = slotIndex;
        this.customName = customName;
    }

    public NameFilterPacket(FriendlyByteBuf buf) {
        this.slotIndex = buf.readInt();
        this.customName = buf.m_130277_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.slotIndex);
        buf.m_130070_(this.customName);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ItemStack itemStack;
            ServerPlayer player = context.getSender();
            if (player != null && (itemStack = player.m_150109_().m_8020_(this.slotIndex)).m_41720_() instanceof NameFilterItem) {
                CompoundTag tag = itemStack.m_41784_();
                tag.m_128359_("custom_name", this.customName);
                player.m_213846_((Component)Component.m_237110_((String)"message.indexer.name_filter.name_updated", (Object[])new Object[]{this.customName}));
            }
        });
        return true;
    }
}

