/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.screen;

import com.agustinbenitez.indexer.network.AttributeFilterPacket;
import com.agustinbenitez.indexer.network.ModNetworking;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class AttributeFilterScreen
extends Screen {
    private static final int GUI_WIDTH = 300;
    private static final int GUI_HEIGHT = 200;
    private EditBox attributeEditBox;
    private Button confirmButton;
    private Button cancelButton;
    private final ItemStack filterItem;
    private final int slotIndex;
    private List<String> suggestions = new ArrayList<String>();
    private int selectedSuggestion = -1;
    private boolean showSuggestions = false;

    public AttributeFilterScreen(ItemStack filterItem, int slotIndex) {
        super((Component)Component.m_237115_((String)"gui.indexer.attribute_filter.title"));
        this.filterItem = filterItem;
        this.slotIndex = slotIndex;
    }

    protected void m_7856_() {
        int guiLeft = (this.f_96543_ - 300) / 2;
        int guiTop = (this.f_96544_ - 200) / 2;
        this.attributeEditBox = new EditBox(this.f_96547_, guiLeft + 20, guiTop + 60, 260, 20, (Component)Component.m_237115_((String)"gui.indexer.attribute_filter.attribute_input"));
        this.attributeEditBox.m_94182_(true);
        this.attributeEditBox.m_94194_(true);
        this.attributeEditBox.m_94186_(true);
        this.attributeEditBox.m_94202_(0xFFFFFF);
        this.attributeEditBox.m_94205_(0xA0A0A0);
        this.attributeEditBox.m_94199_(100);
        if (this.filterItem.m_41782_() && this.filterItem.m_41783_().m_128441_("attribute_filter")) {
            this.attributeEditBox.m_94144_(this.filterItem.m_41783_().m_128461_("attribute_filter"));
        }
        this.attributeEditBox.m_94151_(this::onAttributeChanged);
        this.m_142416_((GuiEventListener)this.attributeEditBox);
        this.confirmButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.indexer.attribute_filter.confirm"), button -> this.confirmAttribute()).m_252987_(guiLeft + 20, guiTop + 150, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.indexer.attribute_filter.cancel"), button -> this.m_7379_()).m_252987_(guiLeft + 120, guiTop + 150, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
        this.m_7522_((GuiEventListener)this.attributeEditBox);
    }

    private void onAttributeChanged(String text) {
        if (text.isEmpty()) {
            this.suggestions.clear();
            this.showSuggestions = false;
            return;
        }
        this.suggestions = ForgeRegistries.ENCHANTMENTS.getKeys().stream().map(ResourceLocation::toString).filter(enchantName -> enchantName.toLowerCase().contains(text.toLowerCase())).limit(10L).collect(Collectors.toList());
        List<String> commonAttributes = List.of("minecraft:sharpness", "minecraft:efficiency", "minecraft:unbreaking", "minecraft:fortune", "minecraft:silk_touch", "minecraft:mending", "minecraft:protection", "minecraft:fire_protection", "minecraft:blast_protection", "minecraft:projectile_protection", "minecraft:thorns", "minecraft:respiration", "minecraft:aqua_affinity", "minecraft:depth_strider", "minecraft:frost_walker", "minecraft:feather_falling", "minecraft:looting", "minecraft:knockback", "minecraft:fire_aspect", "minecraft:sweeping", "minecraft:power", "minecraft:punch", "minecraft:flame", "minecraft:infinity");
        for (String attribute : commonAttributes) {
            if (!attribute.toLowerCase().contains(text.toLowerCase()) || this.suggestions.contains(attribute)) continue;
            this.suggestions.add(attribute);
        }
        this.showSuggestions = !this.suggestions.isEmpty();
        this.selectedSuggestion = -1;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.attributeEditBox.m_93696_() && this.showSuggestions && !this.suggestions.isEmpty()) {
            if (keyCode == 264) {
                this.selectedSuggestion = Math.min(this.selectedSuggestion + 1, this.suggestions.size() - 1);
                return true;
            }
            if (keyCode == 265) {
                this.selectedSuggestion = Math.max(this.selectedSuggestion - 1, -1);
                return true;
            }
            if ((keyCode == 257 || keyCode == 335) && this.selectedSuggestion >= 0 && this.selectedSuggestion < this.suggestions.size()) {
                this.attributeEditBox.m_94144_(this.suggestions.get(this.selectedSuggestion));
                this.showSuggestions = false;
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        int guiLeft = (this.f_96543_ - 300) / 2;
        int guiTop = (this.f_96544_ - 200) / 2;
        guiGraphics.m_280509_(guiLeft, guiTop, guiLeft + 300, guiTop + 200, -1072689136);
        guiGraphics.m_280509_(guiLeft + 1, guiTop + 1, guiLeft + 300 - 1, guiTop + 200 - 1, -13816528);
        MutableComponent title = Component.m_237115_((String)"gui.indexer.attribute_filter.title");
        guiGraphics.m_280653_(this.f_96547_, (Component)title, guiLeft + 150, guiTop + 20, 0xFFFFFF);
        MutableComponent instructions = Component.m_237115_((String)"gui.indexer.attribute_filter.instructions");
        guiGraphics.m_280614_(this.f_96547_, (Component)instructions, guiLeft + 20, guiTop + 40, 0xCCCCCC, false);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.showSuggestions && !this.suggestions.isEmpty()) {
            int suggestionsX = this.attributeEditBox.m_252754_();
            int suggestionsY = this.attributeEditBox.m_252907_() + this.attributeEditBox.m_93694_() + 2;
            int suggestionsWidth = this.attributeEditBox.m_5711_();
            int suggestionHeight = 12;
            int maxSuggestions = Math.min(this.suggestions.size(), 8);
            guiGraphics.m_280509_(suggestionsX, suggestionsY, suggestionsX + suggestionsWidth, suggestionsY + maxSuggestions * suggestionHeight, -536870912);
            for (int i = 0; i < maxSuggestions; ++i) {
                String suggestion = this.suggestions.get(i);
                int y = suggestionsY + i * suggestionHeight;
                if (i == this.selectedSuggestion) {
                    guiGraphics.m_280509_(suggestionsX, y, suggestionsX + suggestionsWidth, y + suggestionHeight, -11908534);
                }
                guiGraphics.m_280056_(this.f_96547_, suggestion, suggestionsX + 4, y + 2, 0xFFFFFF, false);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.showSuggestions && !this.suggestions.isEmpty()) {
            int suggestionsX = this.attributeEditBox.m_252754_();
            int suggestionsY = this.attributeEditBox.m_252907_() + this.attributeEditBox.m_93694_() + 2;
            int suggestionsWidth = this.attributeEditBox.m_5711_();
            int suggestionHeight = 12;
            int maxSuggestions = Math.min(this.suggestions.size(), 8);
            if (mouseX >= (double)suggestionsX && mouseX <= (double)(suggestionsX + suggestionsWidth) && mouseY >= (double)suggestionsY && mouseY <= (double)(suggestionsY + maxSuggestions * suggestionHeight)) {
                int clickedIndex = (int)((mouseY - (double)suggestionsY) / (double)suggestionHeight);
                if (clickedIndex >= 0 && clickedIndex < maxSuggestions) {
                    this.attributeEditBox.m_94144_(this.suggestions.get(clickedIndex));
                    this.showSuggestions = false;
                    return true;
                }
            } else {
                this.showSuggestions = false;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void confirmAttribute() {
        String attribute = this.attributeEditBox.m_94155_().trim();
        if (!attribute.isEmpty()) {
            ModNetworking.sendToServer(new AttributeFilterPacket(this.slotIndex, attribute));
        }
        this.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }
}

