/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.util;

import com.agustinbenitez.indexer.init.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.registries.ForgeRegistries;

public class FilterUtils {
    public static boolean passesFilter(ItemStack itemToCheck, ItemStack filterItem) {
        if (itemToCheck.m_41619_() || filterItem.m_41619_()) {
            return false;
        }
        Item filterType = filterItem.m_41720_();
        if (filterType == ModItems.TOOLS_FILTER.get()) {
            return FilterUtils.isToolItem(itemToCheck);
        }
        if (filterType == ModItems.FOOD_FILTER.get()) {
            return itemToCheck.m_41614_();
        }
        if (filterType == ModItems.FUEL_FILTER.get()) {
            return FilterUtils.isFuelItem(itemToCheck);
        }
        if (filterType == ModItems.CUSTOM_TAG_BLOCKER.get()) {
            return FilterUtils.passesCustomTagFilter(itemToCheck, filterItem);
        }
        if (filterType == ModItems.ATTRIBUTE_FILTER.get()) {
            return FilterUtils.passesAttributeFilter(itemToCheck, filterItem);
        }
        if (filterType == ModItems.NAME_FILTER.get()) {
            return FilterUtils.passesNameFilter(itemToCheck, filterItem);
        }
        return itemToCheck.m_41720_() == filterItem.m_41720_();
    }

    public static boolean isBlockingFilter(ItemStack filterItem) {
        if (filterItem.m_41619_()) {
            return false;
        }
        return filterItem.m_41720_() == ModItems.CUSTOM_TAG_BLOCKER.get();
    }

    private static boolean isToolItem(ItemStack stack) {
        Item item = stack.m_41720_();
        return item instanceof PickaxeItem || item instanceof AxeItem || item instanceof ShovelItem || item instanceof HoeItem || item instanceof SwordItem;
    }

    private static boolean isFuelItem(ItemStack stack) {
        String itemId = stack.m_41720_().m_5524_();
        return itemId.equals("item.minecraft.coal") || itemId.equals("item.minecraft.charcoal") || itemId.equals("item.minecraft.lava_bucket") || itemId.equals("block.minecraft.coal_block") || itemId.equals("block.minecraft.dried_kelp_block");
    }

    private static boolean passesCustomTagFilter(ItemStack itemToCheck, ItemStack filterItem) {
        String filterItemName;
        if (!filterItem.m_41782_()) {
            return true;
        }
        String customTag = filterItem.m_41783_().m_128461_("custom_tag");
        if (customTag.isEmpty()) {
            return true;
        }
        String itemName = itemToCheck.m_41720_().m_5524_();
        if (itemName.equals(filterItemName = customTag)) {
            return false;
        }
        String shortItemName = itemName.replace("item.minecraft.", "").replace("block.minecraft.", "");
        return !shortItemName.equals(filterItemName);
    }

    private static boolean passesAttributeFilter(ItemStack itemToCheck, ItemStack filterItem) {
        if (!filterItem.m_41782_()) {
            return false;
        }
        String attributeFilter = filterItem.m_41783_().m_128461_("attribute_filter");
        if (attributeFilter.isEmpty()) {
            return false;
        }
        if (itemToCheck.m_41793_()) {
            return itemToCheck.getAllEnchantments().keySet().stream().anyMatch(enchantment -> {
                ResourceLocation enchantmentKey = ForgeRegistries.ENCHANTMENTS.getKey(enchantment);
                return enchantment.m_44704_().contains(attributeFilter) || enchantmentKey != null && enchantmentKey.toString().equals(attributeFilter);
            });
        }
        String itemName = itemToCheck.m_41720_().toString().toLowerCase();
        String displayName = itemToCheck.m_41611_().getString().toLowerCase();
        return itemName.contains(attributeFilter.toLowerCase()) || displayName.contains(attributeFilter.toLowerCase()) || itemToCheck.m_204131_().anyMatch(tag -> tag.f_203868_().toString().contains(attributeFilter));
    }

    private static boolean passesNameFilter(ItemStack itemToCheck, ItemStack filterItem) {
        CompoundTag displayTag;
        if (!filterItem.m_41782_()) {
            return false;
        }
        String nameFilter = filterItem.m_41783_().m_128461_("custom_name");
        if (nameFilter.isEmpty()) {
            return false;
        }
        if (itemToCheck.m_41782_() && itemToCheck.m_41783_().m_128441_("display") && (displayTag = itemToCheck.m_41783_().m_128469_("display")).m_128441_("Name")) {
            String anvilName = displayTag.m_128461_("Name");
            if (anvilName.startsWith("{") && anvilName.contains("\"text\"")) {
                try {
                    int textStart = anvilName.indexOf("\"text\":\"") + 8;
                    int textEnd = anvilName.indexOf("\"", textStart);
                    if (textStart > 7 && textEnd > textStart) {
                        String extractedName = anvilName.substring(textStart, textEnd);
                        return extractedName.equals(nameFilter);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return anvilName.equals(nameFilter) || anvilName.equals("{\"text\":\"" + nameFilter + "\"}");
        }
        return false;
    }
}

