/*
 * Decompiled with CFR 0.152.
 */
package org.powell.craftify;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.powell.craftify.CraftifyCommand;
import org.powell.craftify.CraftifyListener;

public final class Craftify
extends JavaPlugin
implements Listener {
    private final HashSet<UUID> discoveredRecipes = new HashSet();
    private CraftifyListener craftifyListener;
    private Craftify main;
    private File file;
    private YamlConfiguration config;

    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.main = this;
        this.craftifyListener = new CraftifyListener(this, this.file, this.config);
        try {
            this.loadConfig("recipes.yml", this.main);
            this.createRecipes();
            this.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "Craftify Recipes Loaded!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getCommand("craftify").setExecutor((CommandExecutor)new CraftifyCommand());
        Bukkit.getPluginManager().registerEvents((Listener)new CraftifyListener(this, this.file, this.config), (Plugin)this);
    }

    public void loadConfig(String fileName, Craftify main) throws Exception {
        if (!main.getDataFolder().exists()) {
            main.getDataFolder().mkdir();
        }
        this.file = new File(main.getDataFolder(), fileName);
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
    }

    public void loadRecipes(YamlConfiguration config, Player player) {
        YamlConfiguration yml = config;
        if (yml.getConfigurationSection("Crafting_Recipes") != null) {
            for (String recipeKey : yml.getConfigurationSection("Crafting_Recipes").getKeys(false)) {
                ItemStack[] ingredients = this.loadIngredients((FileConfiguration)yml, recipeKey);
                ItemStack result = this.loadResult((FileConfiguration)yml, recipeKey);
                if (ingredients.length > 0 && result != null) {
                    NamespacedKey key = new NamespacedKey("bukkit", recipeKey);
                    ShapedRecipe shapedRecipe = this.createShapedRecipe(key, result, ingredients);
                    String cleanedkey = shapedRecipe.getKey().toString();
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("recipe give " + player.getName() + " " + cleanedkey));
                    continue;
                }
                System.out.println("Invalid recipe or missing ingredients for: " + recipeKey);
            }
        } else {
            System.out.println("No Recipes Found");
        }
    }

    private void createRecipes() {
        YamlConfiguration yml = this.config;
        if (yml.getConfigurationSection("Crafting_Recipes") != null) {
            for (String recipeKey : yml.getConfigurationSection("Crafting_Recipes").getKeys(false)) {
                ItemStack[] ingredients = this.loadIngredients((FileConfiguration)yml, recipeKey);
                ItemStack result = this.loadResult((FileConfiguration)yml, recipeKey);
                if (ingredients.length == 0 || result == null) {
                    this.getLogger().warning("Skipping recipe: " + recipeKey + " (Invalid ingredients or missing output)");
                    continue;
                }
                NamespacedKey key = new NamespacedKey("bukkit", recipeKey);
                ShapedRecipe shapedRecipe = this.createShapedRecipe(key, result, ingredients);
                if (shapedRecipe == null) {
                    this.getLogger().warning("Skipping recipe: " + recipeKey + " (Failed to create recipe)");
                    continue;
                }
                Iterator it = Bukkit.recipeIterator();
                while (it.hasNext()) {
                    Recipe recipe = (Recipe)it.next();
                    if (!(recipe instanceof Keyed) || !((Keyed)recipe).getKey().equals((Object)key)) continue;
                    it.remove();
                    this.getLogger().info("Removed duplicate recipe with ID: " + String.valueOf(key));
                    break;
                }
                Bukkit.addRecipe((Recipe)shapedRecipe);
                this.getLogger().info("Registered recipe: " + String.valueOf(key));
            }
        }
    }

    private void unloadRecipes(YamlConfiguration config, Player player) {
        YamlConfiguration yml = config;
        if (yml.getConfigurationSection("Crafting_Recipes") != null) {
            for (String recipeKey : yml.getConfigurationSection("Crafting_Recipes").getKeys(false)) {
                NamespacedKey key = new NamespacedKey("bukkit", recipeKey);
                String cleanedkey = key.toString();
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("recipe take " + player.getName() + " " + cleanedkey));
            }
        } else {
            System.out.println("No Recipes Found");
        }
    }

    private ItemStack[] loadIngredients(FileConfiguration config, String recipeKey) {
        ItemStack[] ingredients = new ItemStack[9];
        char[] validSlots = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I'};
        for (int i = 0; i < validSlots.length; ++i) {
            char slot = validSlots[i];
            String ingredientPath = "Crafting_Recipes." + recipeKey + ".ingredient." + slot;
            if (config.contains(ingredientPath)) {
                String materialName = config.getString(ingredientPath + ".type");
                int amount = config.getInt(ingredientPath + ".amount", 1);
                Material material = Material.getMaterial((String)materialName);
                if (material != null) {
                    ingredients[i] = new ItemStack(material, amount);
                    continue;
                }
                this.getLogger().warning("Invalid material for slot " + slot + " in recipe " + recipeKey + ": " + materialName);
                ingredients[i] = new ItemStack(Material.AIR);
                continue;
            }
            ingredients[i] = new ItemStack(Material.AIR);
        }
        return ingredients;
    }

    private ItemStack loadResult(FileConfiguration config, String recipeKey) {
        ItemMeta meta;
        if (!config.contains("Crafting_Recipes." + recipeKey + ".output.type")) {
            return null;
        }
        Material material = Material.matchMaterial((String)config.getString("Crafting_Recipes." + recipeKey + ".output.type"));
        if (material == null) {
            this.getLogger().warning("Invalid material for recipe: " + recipeKey);
            return null;
        }
        int amount = config.getInt("Crafting_Recipes." + recipeKey + ".output.amount", 1);
        ItemStack result = new ItemStack(material, amount);
        if ((config.contains("Crafting_Recipes." + recipeKey + ".output.display-name") || config.contains("Crafting_Recipes." + recipeKey + ".output.enchants")) && (meta = result.getItemMeta()) != null) {
            ConfigurationSection enchantsSection;
            if (config.contains("Crafting_Recipes." + recipeKey + ".output.display-name")) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("Crafting_Recipes." + recipeKey + ".output.display-name")));
            }
            if ((enchantsSection = config.getConfigurationSection("Crafting_Recipes." + recipeKey + ".output.enchants")) != null) {
                for (String enchantKey : enchantsSection.getKeys(false)) {
                    Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchantKey));
                    int level = enchantsSection.getInt(enchantKey, 1);
                    if (enchantment != null) {
                        meta.addEnchant(enchantment, level, true);
                        continue;
                    }
                    this.getLogger().warning("Invalid enchantment: " + enchantKey);
                }
            }
            result.setItemMeta(meta);
        }
        return result;
    }

    private ShapedRecipe createShapedRecipe(NamespacedKey key, ItemStack result, ItemStack[] ingredients) {
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"ABC", "DEF", "GHI"});
        char[] slots = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I'};
        for (int i = 0; i < 9; ++i) {
            if (ingredients[i] == null || ingredients[i].getType() == Material.AIR) continue;
            recipe.setIngredient(slots[i], ingredients[i].getType());
        }
        return recipe;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        this.loadRecipes(this.config, e.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.unloadRecipes(this.config, e.getPlayer());
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }
}

