/*
 * Decompiled with CFR 0.152.
 */
package org.powell.craftify;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.powell.craftify.Craftify;

public class CraftifyListener
implements Listener {
    private final File file;
    private final Craftify main;
    private YamlConfiguration config;

    public CraftifyListener(Craftify main, File file, YamlConfiguration config) {
        this.main = main;
        this.file = file;
        this.config = config;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getView().getTitle().equals(String.valueOf(ChatColor.DARK_AQUA) + "Craftify Menu") && e.getCurrentItem() != null) {
            Player player = (Player)e.getWhoClicked();
            switch (e.getRawSlot()) {
                case 0: {
                    e.setCancelled(true);
                    break;
                }
                case 44: {
                    e.setCancelled(true);
                    ItemStack[] contents = e.getInventory().getContents();
                    ItemStack item = contents[24];
                    NamespacedKey key = NamespacedKey.randomKey();
                    String cleanedKey = key.getKey().replace("bukkit:", "");
                    if (item != null) {
                        ShapedRecipe recipe = new ShapedRecipe(key, item);
                        recipe.shape(new String[]{"ABC", "DEF", "GHI"});
                        if (contents[10] != null) {
                            recipe.setIngredient('A', contents[10].getType());
                        }
                        if (contents[11] != null) {
                            recipe.setIngredient('B', contents[11].getType());
                        }
                        if (contents[12] != null) {
                            recipe.setIngredient('C', contents[12].getType());
                        }
                        if (contents[19] != null) {
                            recipe.setIngredient('D', contents[19].getType());
                        }
                        if (contents[20] != null) {
                            recipe.setIngredient('E', contents[20].getType());
                        }
                        if (contents[21] != null) {
                            recipe.setIngredient('F', contents[21].getType());
                        }
                        if (contents[28] != null) {
                            recipe.setIngredient('G', contents[28].getType());
                        }
                        if (contents[29] != null) {
                            recipe.setIngredient('H', contents[29].getType());
                        }
                        if (contents[30] != null) {
                            recipe.setIngredient('I', contents[30].getType());
                        }
                        try {
                            this.config = YamlConfiguration.loadConfiguration((File)this.file);
                            Bukkit.addRecipe((Recipe)recipe);
                            System.out.println(key);
                            String basePath = "Crafting_Recipes." + cleanedKey;
                            this.config.set(basePath + ".shape", (Object)recipe.getShape());
                            ConfigurationSection ingredientSection = this.config.createSection(basePath + ".ingredient");
                            for (Map.Entry entry : recipe.getIngredientMap().entrySet()) {
                                if (entry.getValue() == null) continue;
                                ConfigurationSection itemSection = ingredientSection.createSection(((Character)entry.getKey()).toString());
                                this.saveItem(itemSection, (ItemStack)entry.getValue());
                            }
                            ConfigurationSection outputSection = this.config.createSection(basePath + ".output");
                            this.saveItem(outputSection, item);
                            this.config.save(this.file);
                        }
                        catch (IOException a) {
                            a.printStackTrace();
                        }
                        catch (IndexOutOfBoundsException i) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "You need an ingredient.");
                        }
                        for (Player p : Bukkit.getOnlinePlayers()) {
                            p.discoverRecipe(key);
                        }
                        break;
                    }
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You need an output.");
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 22: 
                case 23: 
                case 25: 
                case 26: 
                case 27: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: {
                    e.setCancelled(true);
                }
                default: {
                    return;
                }
            }
            player.closeInventory();
        }
    }

    private void saveItem(ConfigurationSection section, ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        section.set("type", (Object)item.getType().toString());
        section.set("amount", (Object)item.getAmount());
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        if (meta.hasDisplayName()) {
            section.set("display-name", (Object)meta.getDisplayName());
        }
        if (meta.hasEnchants()) {
            ConfigurationSection enchantsSection = section.createSection("enchants");
            for (Map.Entry entry : meta.getEnchants().entrySet()) {
                String enchantmentKey = ((Enchantment)entry.getKey()).getKey().getKey();
                enchantsSection.set(enchantmentKey, entry.getValue());
            }
        }
        if (meta.hasLore()) {
            section.set("lore", (Object)meta.getLore());
        }
        if (!meta.getItemFlags().isEmpty()) {
            List flags = meta.getItemFlags().stream().map(Enum::name).collect(Collectors.toList());
            section.set("item-flags", flags);
        }
    }

    @EventHandler
    public void onCraft(CraftItemEvent event) {
        Recipe recipe = event.getRecipe();
        if (!(recipe instanceof ShapedRecipe)) {
            return;
        }
        ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
        ItemStack result = shapedRecipe.getResult();
        ItemMeta meta = result.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            ItemStack finalItem = result.clone();
            finalItem.setItemMeta(meta);
            event.getInventory().setResult(finalItem);
        }
    }
}

