/*
 * Decompiled with CFR 0.152.
 */
package org.powell.craftify;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.powell.craftify.CraftifyCommand;
import org.powell.craftify.CraftifyListener;

public final class Craftify
extends JavaPlugin
implements Listener {
    private final HashSet<UUID> discoveredRecipes = new HashSet();
    private CraftifyListener craftifyListener;
    private Craftify main;
    private File file;
    private YamlConfiguration config;

    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.main = this;
        this.craftifyListener = new CraftifyListener(this, this.file, this.config);
        try {
            this.loadConfig("recipes.yml", this.main);
            this.createRecipes();
            this.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "Craftify Recipes Loaded!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getCommand("craftify").setExecutor((CommandExecutor)new CraftifyCommand());
        Bukkit.getPluginManager().registerEvents((Listener)new CraftifyListener(this, this.file, this.config), (Plugin)this);
    }

    public void loadConfig(String fileName, Craftify main) throws Exception {
        if (!main.getDataFolder().exists()) {
            main.getDataFolder().mkdir();
        }
        this.file = new File(main.getDataFolder(), fileName);
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
    }

    public void loadRecipes(YamlConfiguration config, Player player) {
        YamlConfiguration yml = config;
        if (yml.getConfigurationSection("Crafting_Recipes") != null) {
            for (String recipeKey : yml.getConfigurationSection("Crafting_Recipes").getKeys(false)) {
                ItemStack[] ingredients = this.loadIngredients((FileConfiguration)yml, recipeKey);
                ItemStack result = this.loadResult((FileConfiguration)yml, recipeKey);
                if (ingredients.length > 0 && result != null) {
                    NamespacedKey key = new NamespacedKey("bukkit", recipeKey);
                    ShapedRecipe shapedRecipe = this.createShapedRecipe(key, result, ingredients);
                    String cleanedkey = shapedRecipe.getKey().toString();
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("recipe give " + player.getName() + " " + cleanedkey));
                    continue;
                }
                System.out.println("Invalid recipe or missing ingredients for: " + recipeKey);
            }
        } else {
            System.out.println("No Recipes Found");
        }
    }

    private void createRecipes() {
        YamlConfiguration yml = this.config;
        if (yml.getConfigurationSection("Crafting_Recipes") != null) {
            for (String recipeKey : yml.getConfigurationSection("Crafting_Recipes").getKeys(false)) {
                ItemStack[] ingredients = this.loadIngredients((FileConfiguration)yml, recipeKey);
                ItemStack result = this.loadResult((FileConfiguration)yml, recipeKey);
                if (ingredients.length == 0 || result == null) {
                    this.getLogger().warning("Skipping recipe: " + recipeKey + " (Invalid ingredients or missing output)");
                    continue;
                }
                NamespacedKey key = new NamespacedKey("bukkit", recipeKey);
                ShapedRecipe shapedRecipe = this.createShapedRecipe(key, result, ingredients);
                if (shapedRecipe == null) {
                    this.getLogger().warning("Skipping recipe: " + recipeKey + " (Failed to create recipe)");
                    continue;
                }
                Iterator it = Bukkit.recipeIterator();
                while (it.hasNext()) {
                    Recipe recipe = (Recipe)it.next();
                    if (!(recipe instanceof Keyed) || !((Keyed)recipe).getKey().equals((Object)key)) continue;
                    it.remove();
                    this.getLogger().info("Removed duplicate recipe with ID: " + String.valueOf(key));
                    break;
                }
                Bukkit.addRecipe((Recipe)shapedRecipe);
                this.getLogger().info("Registered recipe: " + String.valueOf(key));
            }
        }
    }

    private void unloadRecipes(YamlConfiguration config, Player player) {
        YamlConfiguration yml = config;
        if (yml.getConfigurationSection("Crafting_Recipes") != null) {
            for (String recipeKey : yml.getConfigurationSection("Crafting_Recipes").getKeys(false)) {
                NamespacedKey key = new NamespacedKey("bukkit", recipeKey);
                String cleanedkey = key.toString();
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("recipe take " + player.getName() + " " + cleanedkey));
            }
        } else {
            System.out.println("No Recipes Found");
        }
    }

    private ItemStack[] loadIngredients(FileConfiguration config, String recipeKey) {
        ItemStack[] ingredients = new ItemStack[9];
        char[] validSlots = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I'};
        for (int i = 0; i < validSlots.length; ++i) {
            char slot = validSlots[i];
            String ingredientPath = "Crafting_Recipes." + recipeKey + ".ingredient." + slot;
            ingredients[i] = config.contains(ingredientPath + ".type") ? this.loadItem(config, ingredientPath) : new ItemStack(Material.AIR);
        }
        return ingredients;
    }

    private ItemStack loadResult(FileConfiguration config, String recipeKey) {
        String basePath = "Crafting_Recipes." + recipeKey + ".output";
        if (!config.contains(basePath + ".type")) {
            return null;
        }
        return this.loadItem(config, basePath);
    }

    private ShapedRecipe createShapedRecipe(NamespacedKey key, ItemStack result, ItemStack[] ingredients) {
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"ABC", "DEF", "GHI"});
        char[] slots = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I'};
        for (int i = 0; i < 9; ++i) {
            if (ingredients[i] == null || ingredients[i].getType() == Material.AIR) continue;
            recipe.setIngredient(slots[i], (RecipeChoice)new RecipeChoice.ExactChoice(ingredients[i]));
        }
        return recipe;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        this.loadRecipes(this.config, e.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.unloadRecipes(this.config, e.getPlayer());
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    private ItemStack loadItem(FileConfiguration config, String path) {
        String typeName = config.getString(path + ".type");
        if (typeName == null) {
            return new ItemStack(Material.AIR);
        }
        Material material = Material.matchMaterial((String)typeName);
        if (material == null) {
            return new ItemStack(Material.AIR);
        }
        int amount = config.getInt(path + ".amount", 1);
        ItemStack item = new ItemStack(material, amount);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            ConfigurationSection enchantsSection;
            if (config.contains(path + ".display-name")) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString(path + ".display-name")));
            }
            if ((enchantsSection = config.getConfigurationSection(path + ".enchants")) != null) {
                for (String enchantKey : enchantsSection.getKeys(false)) {
                    Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchantKey));
                    int level = enchantsSection.getInt(enchantKey, 1);
                    if (enchantment == null) continue;
                    meta.addEnchant(enchantment, level, true);
                }
            }
            if (config.contains(path + ".lore")) {
                meta.setLore(config.getStringList(path + ".lore"));
            }
            if ((material == Material.POTION || material == Material.SPLASH_POTION || material == Material.LINGERING_POTION) && meta instanceof PotionMeta) {
                ConfigurationSection effects;
                PotionMeta potionMeta = (PotionMeta)meta;
                String baseType = config.getString(path + ".potion.base-type");
                boolean extended = config.getBoolean(path + ".potion.extended", false);
                boolean upgraded = config.getBoolean(path + ".potion.upgraded", false);
                if (baseType != null) {
                    try {
                        PotionType type = PotionType.valueOf((String)baseType);
                        potionMeta.setBasePotionData(new PotionData(type, extended, upgraded));
                    }
                    catch (IllegalArgumentException type) {
                        // empty catch block
                    }
                }
                if ((effects = config.getConfigurationSection(path + ".potion.custom-effects")) != null) {
                    for (String k : effects.getKeys(false)) {
                        PotionEffectType pt;
                        String effType = effects.getString(k + ".type");
                        int amplifier = effects.getInt(k + ".amplifier", 0);
                        int duration = effects.getInt(k + ".duration", 0);
                        boolean ambient = effects.getBoolean(k + ".ambient", false);
                        boolean particles = effects.getBoolean(k + ".particles", true);
                        boolean icon = effects.getBoolean(k + ".icon", true);
                        if (effType == null || (pt = PotionEffectType.getByName((String)effType)) == null) continue;
                        potionMeta.addCustomEffect(new PotionEffect(pt, duration, amplifier, ambient, particles, icon), true);
                    }
                }
                meta = potionMeta;
            }
            item.setItemMeta(meta);
        }
        return item;
    }
}

