/*
 * Decompiled with CFR 0.152.
 */
package org.powell.craftify;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.powell.craftify.Craftify;

public class CraftifyListener
implements Listener {
    private final File file;
    private final Craftify main;
    private YamlConfiguration config;

    public CraftifyListener(Craftify main, File file, YamlConfiguration config) {
        this.main = main;
        this.file = file;
        this.config = config;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getView().getTitle().equals(String.valueOf(ChatColor.DARK_AQUA) + "Craftify Menu") && e.getCurrentItem() != null) {
            Player player = (Player)e.getWhoClicked();
            switch (e.getRawSlot()) {
                case 0: {
                    e.setCancelled(true);
                    break;
                }
                case 44: {
                    e.setCancelled(true);
                    ItemStack[] contents = e.getInventory().getContents();
                    ItemStack item = contents[24];
                    NamespacedKey key = NamespacedKey.randomKey();
                    String cleanedKey = key.getKey().replace("bukkit:", "");
                    if (item != null) {
                        ShapedRecipe recipe = new ShapedRecipe(key, item);
                        recipe.shape(new String[]{"ABC", "DEF", "GHI"});
                        if (contents[10] != null) {
                            recipe.setIngredient('A', (RecipeChoice)new RecipeChoice.ExactChoice(contents[10]));
                        }
                        if (contents[11] != null) {
                            recipe.setIngredient('B', (RecipeChoice)new RecipeChoice.ExactChoice(contents[11]));
                        }
                        if (contents[12] != null) {
                            recipe.setIngredient('C', (RecipeChoice)new RecipeChoice.ExactChoice(contents[12]));
                        }
                        if (contents[19] != null) {
                            recipe.setIngredient('D', (RecipeChoice)new RecipeChoice.ExactChoice(contents[19]));
                        }
                        if (contents[20] != null) {
                            recipe.setIngredient('E', (RecipeChoice)new RecipeChoice.ExactChoice(contents[20]));
                        }
                        if (contents[21] != null) {
                            recipe.setIngredient('F', (RecipeChoice)new RecipeChoice.ExactChoice(contents[21]));
                        }
                        if (contents[28] != null) {
                            recipe.setIngredient('G', (RecipeChoice)new RecipeChoice.ExactChoice(contents[28]));
                        }
                        if (contents[29] != null) {
                            recipe.setIngredient('H', (RecipeChoice)new RecipeChoice.ExactChoice(contents[29]));
                        }
                        if (contents[30] != null) {
                            recipe.setIngredient('I', (RecipeChoice)new RecipeChoice.ExactChoice(contents[30]));
                        }
                        try {
                            this.config = YamlConfiguration.loadConfiguration((File)this.file);
                            Bukkit.addRecipe((Recipe)recipe);
                            System.out.println(key);
                            String basePath = "Crafting_Recipes." + cleanedKey;
                            this.config.set(basePath + ".shape", (Object)recipe.getShape());
                            ConfigurationSection ingredientSection = this.config.createSection(basePath + ".ingredient");
                            this.saveGridItem(ingredientSection, "A", contents[10]);
                            this.saveGridItem(ingredientSection, "B", contents[11]);
                            this.saveGridItem(ingredientSection, "C", contents[12]);
                            this.saveGridItem(ingredientSection, "D", contents[19]);
                            this.saveGridItem(ingredientSection, "E", contents[20]);
                            this.saveGridItem(ingredientSection, "F", contents[21]);
                            this.saveGridItem(ingredientSection, "G", contents[28]);
                            this.saveGridItem(ingredientSection, "H", contents[29]);
                            this.saveGridItem(ingredientSection, "I", contents[30]);
                            ConfigurationSection outputSection = this.config.createSection(basePath + ".output");
                            this.saveItem(outputSection, item);
                            this.config.save(this.file);
                        }
                        catch (IOException a) {
                            a.printStackTrace();
                        }
                        catch (IndexOutOfBoundsException i) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "You need an ingredient.");
                        }
                        for (Player p : Bukkit.getOnlinePlayers()) {
                            p.discoverRecipe(key);
                        }
                        break;
                    }
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You need an output.");
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 22: 
                case 23: 
                case 25: 
                case 26: 
                case 27: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: {
                    e.setCancelled(true);
                }
                default: {
                    return;
                }
            }
            player.closeInventory();
        }
    }

    private void saveGridItem(ConfigurationSection ingredientSection, String letter, ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        ConfigurationSection itemSection = ingredientSection.createSection(letter);
        this.saveItem(itemSection, item);
    }

    private void saveItem(ConfigurationSection section, ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        section.set("type", (Object)item.getType().toString());
        section.set("amount", (Object)item.getAmount());
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        if (meta.hasDisplayName()) {
            section.set("display-name", (Object)meta.getDisplayName());
        }
        if (meta.hasEnchants()) {
            ConfigurationSection enchantsSection = section.createSection("enchants");
            for (Map.Entry entry : meta.getEnchants().entrySet()) {
                String enchantmentKey = ((Enchantment)entry.getKey()).getKey().getKey();
                enchantsSection.set(enchantmentKey, entry.getValue());
            }
        }
        if (meta.hasLore()) {
            section.set("lore", (Object)meta.getLore());
        }
        if (!meta.getItemFlags().isEmpty()) {
            List flags = meta.getItemFlags().stream().map(Enum::name).collect(Collectors.toList());
            section.set("item-flags", flags);
        }
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            ConfigurationSection pot = section.createSection("potion");
            PotionType type = potionMeta.getBasePotionType();
            if (type != null) {
                pot.set("base-type", (Object)type.name());
            }
            if (potionMeta.hasCustomEffects()) {
                ConfigurationSection effects = pot.createSection("custom-effects");
                int idx = 0;
                for (PotionEffect eff : potionMeta.getCustomEffects()) {
                    ConfigurationSection es = effects.createSection(String.valueOf(idx++));
                    PotionEffectType et = eff.getType();
                    es.set("type", (Object)(et != null ? et.getName() : ""));
                    es.set("amplifier", (Object)eff.getAmplifier());
                    es.set("duration", (Object)eff.getDuration());
                    es.set("ambient", (Object)eff.isAmbient());
                    es.set("particles", (Object)eff.hasParticles());
                    es.set("icon", (Object)eff.hasIcon());
                }
            }
        }
    }
}

