/*
 * Decompiled with CFR 0.152.
 */
package me.darksnakex.villagerfollow;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import me.darksnakex.villagerfollow.VillagerFollowCommand;
import me.darksnakex.villagerfollow.bukkit.Metrics;
import me.darksnakex.villagerfollow.interactions.VillagerInteractionDropEmerald;
import me.darksnakex.villagerfollow.interactions.VillagerInteractionGiveEmerald;
import me.darksnakex.villagerfollow.interactions.VillagerInteractionHandEmerald;
import me.darksnakex.villagerfollow.updater.NotifyAdmin;
import me.darksnakex.villagerfollow.updater.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class VillagerFollow
extends JavaPlugin {
    public String rutaConfig;
    private YamlConfiguration messages = null;
    private File messagesFile = null;
    public final PluginDescriptionFile pdffile = this.getDescription();
    public final String version = this.pdffile.getVersion();
    public String nombre = ChatColor.YELLOW + "[" + ChatColor.GREEN + this.pdffile.getName() + ChatColor.YELLOW + "] " + ChatColor.GRAY;
    public static boolean isSpigot = true;

    public void onEnable() {
        this.registerprefix();
        Bukkit.getConsoleSender().sendMessage(this.nombre + "has been enabled");
        this.registerMessages();
        this.registrosdecomandos();
        this.registrareventos();
        this.registerConfig();
        this.checkMissingConfigKeys();
        if (VillagerFollow.isRunningOnSpigot()) {
            Bukkit.getConsoleSender().sendMessage(this.nombre + "Using Spigot version...");
        } else {
            Bukkit.getConsoleSender().sendMessage(this.nombre + "Using Paper version...");
            isSpigot = false;
        }
        new Metrics(this, 19294);
        new UpdateChecker(this, 111553).getVersion(version -> {
            if (this.getDescription().getVersion().equalsIgnoreCase((String)version)) {
                Bukkit.getConsoleSender().sendMessage(this.nombre + "There is not a new update available.");
            } else {
                Bukkit.getConsoleSender().sendMessage(this.nombre + "There is a new update available.");
            }
        });
    }

    public static boolean isRunningOnSpigot() {
        return !Bukkit.getServer().getName().equalsIgnoreCase("Paper");
    }

    public void onDisable() {
        Bukkit.getConsoleSender().sendMessage(this.nombre + "has been disabled");
    }

    public void registrosdecomandos() {
        this.getCommand("villagerfollow").setExecutor((CommandExecutor)new VillagerFollowCommand(this));
    }

    public void registrareventos() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new VillagerInteractionHandEmerald(this), (Plugin)this);
        pm.registerEvents((Listener)new NotifyAdmin(this), (Plugin)this);
        pm.registerEvents((Listener)new VillagerInteractionDropEmerald(this), (Plugin)this);
        pm.registerEvents((Listener)new VillagerInteractionGiveEmerald(this), (Plugin)this);
    }

    public void registerConfig() {
        VillagerInteractionHandEmerald.onPluginReload();
        VillagerInteractionDropEmerald.onPluginReload2();
        File config = new File(this.getDataFolder(), "config.yml");
        this.rutaConfig = config.getPath();
        if (!config.exists()) {
            this.getConfig().options().copyDefaults(true);
            this.saveConfig();
        }
    }

    public FileConfiguration getMessages() {
        if (this.messages == null) {
            this.reloadMessages();
        }
        return this.messages;
    }

    public void reloadMessages() {
        if (this.messages == null) {
            this.messagesFile = new File(this.getDataFolder(), "messages.yml");
        }
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        try {
            InputStreamReader defConfigStream = new InputStreamReader(this.getResource("messages.yml"), "UTF8");
            if (defConfigStream != null) {
                YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)defConfigStream);
                this.messages.setDefaults((Configuration)defConfig);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void saveMessages() {
        try {
            this.messages.save(this.messagesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void registerMessages() {
        this.messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.saveResource("messages.yml", false);
        }
    }

    public void registerprefix() {
        FileConfiguration messagesConfig = this.getMessages();
        this.nombre = ChatColor.translateAlternateColorCodes((char)'&', (String)(messagesConfig.getString("prefix") + " \u00a77"));
    }

    private void checkMissingConfigKeys() {
        FileConfiguration config = this.getConfig();
        boolean modificado = false;
        if (!config.isSet("Config.check-update")) {
            config.set("Config.check-update", (Object)true);
            modificado = true;
        }
        if (!config.isSet("Config.villager-follow")) {
            config.set("Config.villager-follow", (Object)true);
            modificado = true;
        }
        if (!config.isSet("Config.villager-follow-player")) {
            config.set("Config.villager-follow-player", (Object)true);
            modificado = true;
        }
        if (!config.isSet("Config.villager-follow-radius")) {
            config.set("Config.villager-follow-radius", (Object)12);
            modificado = true;
        }
        if (!config.isSet("Config.villager-allow-goto-emerald")) {
            config.set("Config.villager-allow-goto-emerald", (Object)true);
            modificado = true;
        }
        if (!config.isSet("Config.villager-allow-catch-emerald")) {
            config.set("Config.villager-allow-catch-emerald", (Object)true);
            modificado = true;
        }
        if (!config.isSet("Config.villager-pay-follow")) {
            config.set("Config.villager-pay-follow", (Object)true);
            modificado = true;
        }
        if (!config.isSet("Config.villager-pay-follow-time")) {
            config.set("Config.villager-pay-follow-time", (Object)120);
            modificado = true;
        }
        if (!config.isSet("Config.villager-allow-catch-emerald-heal")) {
            config.set("Config.villager-allow-catch-emerald-heal", (Object)true);
            modificado = true;
        }
        if (modificado) {
            this.saveConfig();
        }
    }
}

